Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate gcc-c++
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define __cmake_in_source_build 1

Name:           tagainijisho
Version:        1.0.3
Release:        alt1_16
Summary:        A free Japanese dictionary and study assistant

License:        GPLv3+ and CC-BY-SA
URL:            http://www.tagaini.net/
Source0:        https://github.com/Gnurou/tagainijisho/archive/1.0.3/%{name}-%{version}.tar.gz
Patch0:         %{name}-1.0.3-fts3_tokenizer.patch

BuildRequires:  libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools
BuildRequires:  ctest cmake
BuildRequires:  libsqlite3-devel > 3.7.8
BuildRequires:  desktop-file-utils
%if 0%{?fedora}
BuildRequires:  libappstream-glib
%endif
Requires:       %{name}-common = %{version}-%{release}
Requires:       %{name}-dic-en = %{version}-%{release}
Source44: import.info

%description
Tagaini Jisho is a free, open-source Japanese dictionary and kanji lookup tool
that is available for Windows, MacOS X and Linux and aims at becoming your
Japanese study assistant. It allows you to quickly search for entries and mark
those that you wish to study, along with tags and personal notes. It also let
you train entries you are studying and follows your progression in remembering
them. Finally, it makes it easy to review entries you did not remember by
listing them on screen or printing them on a small booklet.

Tagaini Jisho also features complete stroke order animations for more than
6000 kanji.

%package common
Group: Other
Summary:        Common files of Tagaini Jisho
License:        CC-BY-SA
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description common
Common files of Tagaini Jisho

%package dic-de
Group: Other
Summary:        Tagaini Jisho Japanese/German dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-de
A Japanese/German dictionary for Tagaini Jisho.

%package dic-en
Group: Other
Summary:        Tagaini Jisho Japanese/English dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-en
A Japanese/English dictionary for Tagaini Jisho.

%package dic-es
Group: Other
Summary:        Tagaini Jisho Japanese/Spanish dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-es
A Japanese/Spanish dictionary for Tagaini Jisho.

%package dic-fr
Group: Other
Summary:        Tagaini Jisho Japanese/French dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-fr
A Japanese/French dictionary for Tagaini Jisho.

%package dic-it
Group: Other
Summary:        Tagaini Jisho Japanese/Italian dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-it
A Japanese/Italian dictionary for Tagaini Jisho.

%package dic-pt
Group: Other
Summary:        Tagaini Jisho Japanese/Portuguese dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-pt
A Japanese/Portuguese dictionary for Tagaini Jisho.

%package dic-ru
Group: Other
Summary:        Tagaini Jisho Japanese/Russian dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-ru
A Japanese/Russian dictionary for Tagaini Jisho.

%package dic-th
Group: Other
Summary:        Tagaini Jisho Japanese/Thai dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-th
A Japanese/Thai dictionary for Tagaini Jisho.

%package dic-tr
Group: Other
Summary:        Tagaini Jisho Japanese/Turkish dictionary
License:        CC-BY-SA
BuildArch:      noarch
Provides:       %{name}-dic = %{version}-%{release}
Requires:       %{name}-common = %{version}-%{release}

%description dic-tr
A Japanese/Turkish dictionary for Tagaini Jisho.


%prep
%setup -q
%patch0 -p1 -b .fts3_tokenizer
rm -rf ./3rdparty/sqlite

%build
%{fedora_v2_cmake} .

%make_build


%install
%makeinstall_std

%find_lang %{name} --with-qt
desktop-file-validate $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop

%if 0%{?rhel}
rm -f $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.appdata.xml
%else
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
mv $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.appdata.xml \
   $RPM_BUILD_ROOT%{_datadir}/appdata
appstream-util validate-relax --nonet $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml
%endif

%files -f %{name}.lang
%doc doc/AUTHORS COPYING.txt
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.*
%if 0%{?fedora}
%{_datadir}/appdata/*.appdata.xml
%endif

%files common
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*.css
%{_datadir}/%{name}/*.html
%{_datadir}/%{name}/doc
%{_datadir}/%{name}/jmdict.db
%{_datadir}/%{name}/kanjidic2.db

%files dic-de
%{_datadir}/%{name}/jmdict-de.db
%{_datadir}/%{name}/kanjidic2-de.db

%files dic-en
%{_datadir}/%{name}/jmdict-en.db
%{_datadir}/%{name}/kanjidic2-en.db

%files dic-es
%{_datadir}/%{name}/jmdict-es.db
%{_datadir}/%{name}/kanjidic2-es.db

%files dic-fr
%{_datadir}/%{name}/jmdict-fr.db
%{_datadir}/%{name}/kanjidic2-fr.db

%files dic-it
%{_datadir}/%{name}/jmdict-it.db
%{_datadir}/%{name}/kanjidic2-it.db

%files dic-pt
%{_datadir}/%{name}/jmdict-pt.db
%{_datadir}/%{name}/kanjidic2-pt.db

%files dic-ru
%{_datadir}/%{name}/jmdict-ru.db
%{_datadir}/%{name}/kanjidic2-ru.db

%files dic-th
%{_datadir}/%{name}/jmdict-th.db
%{_datadir}/%{name}/kanjidic2-th.db

%files dic-tr
%{_datadir}/%{name}/jmdict-tr.db
%{_datadir}/%{name}/kanjidic2-tr.db


%changelog
