# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Errno.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name taktuk
%define major		3
%define libname		lib%{name}%{major}
%define develname	lib%{name}-devel
%define module		%{name}
%define pname		perl-%{module}

Name:		taktuk
Version:	3.7.7
Release:	alt1_4
Summary:	Parallel, scalable launcher for cluster and lightweight grids
License:	GPLv2+
Group:		Networking/Remote access
Url:		http://taktuk.gforge.inria.fr/
Source0:	https://gforge.inria.fr/frs/download.php/37055/%{name}-%{version}.tar.gz

Provides:	parallel-tools
Source44: import.info

%description
TakTuk is a tool for deploying parallel remote executions of commands to a
potentially large set of remote nodes. It spreads itself using an adaptive
algorithm and sets up an interconnection network to transport commands and
perform I/Os multiplexing/demultiplexing. The TakTuk mechanics dynamically
 adapt to environment (machine performance and current load, network
contention) by using a reactive work-stealing algorithm that mix local
parallelization and work distribution.

%package -n	%{libname}
Summary:	Parallel, scalable launcher for cluster devel
Group:		System/Libraries

%description -n	%{libname}
TakTuk is a tool for deploying parallel remote executions of commands to a
potentially large set of remote nodes.
All libs.

%package -n	%{develname}
Summary:	Taktuk header files and static libraries
Group:		Development/Other
Requires:	%{libname} = %{version}
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}

%description -n	%{develname}
Taktuk header files and static libraries.

%package -n	%{pname}
Summary:	Taktuk Perl file
Group:		Development/Perl
Requires:	%{name} = %{version}

%description -n	%{pname}
Taktuk Perl Package.

%prep
%setup -q

# FIXME for correct assignment of rights of files and for file-not-utf8
chmod 0644 {AUTHORS,README,NEWS,COPYING,TODO}
iconv -f iso8859-1 -t utf-8 AUTHORS > AUTHORS.conv && mv -f AUTHORS.conv AUTHORS

%build
%configure --disable-static
%make_build

pushd Perl-Module
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor DESTDIR=%{buildroot}
%make_build
popd

%install
%makeinstall_std

pushd Perl-Module
%makeinstall_std
popd

# we don't want these
find %{buildroot} -name '*.la' -delete

cp -pr taktuk-light %{buildroot}%{_bindir}/taktuk-light

# FIXME for correct assignment of rights of Pilot.pm and taktuk-light files
chmod 0755 %{buildroot}%{_bindir}/taktuk-light
chmod 0644 %{buildroot}%{perl_vendor_privlib}/TakTuk/Pilot.pm

%files
%doc %{_defaultdocdir}/%{name}
%{_bindir}/taktuk
%{_bindir}/taktuk-light
%{_mandir}/man1/*

%files -n %{libname}
%doc AUTHORS ChangeLog COPYING DISCLAIMER NEWS README TODO *.html
%{_libdir}/lib%{name}.so.%{major}
%{_libdir}/lib%{name}.so.%{major}.*

%files -n %{develname}
%{_libdir}/lib%{name}.so
%{_includedir}/*
%{_libdir}/pkgconfig/%{name}.pc

%files -n %{pname}
%doc AUTHORS ChangeLog COPYING DISCLAIMER NEWS README TODO *.html
%{perl_vendor_privlib}/*


%changelog
