# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	A menu-driven file backup system
Name:		taper
Version:	7.0
Release:	alt1_0.pre118
License:	GPL
Group:		Archiving/Backup
URL:		http://taper.sourceforge.net/
Source0:	http://switch.dl.sourceforge.net/sourceforge/taper/%{name}-%{version}pre1.tar.bz2
Patch0:		taper-7.0pre1-sparc.patch
Patch1:		taper-7.0pre1-remove-conflicting-type.patch
Patch2:		taper-7.0pre-1-umode_t.patch
Patch3:		taper-7.0pre1-LDFLAGS.diff
BuildRequires:	ncurses-devel
Source44: import.info

%description
Taper is a backup and restoration program with a friendly user
interface.  Files may be backed up to a tape drive or to a hard disk.
The interface for selecting files to be backed up/restored is very
similar to the Midnight Commander interface, and allows easy traversal
of directories.  Taper supports recursive selection of directories.
Taper also supports backing up SCSI, ftape, zftape and removable drives.
By default, taper is set for incremental backups and automatic most
recent restore.

Install the taper package if you need a user friendly file backup and
restoration program.

%prep
%setup -q -n %{name}-%{version}pre-1

%ifarch %{sunsparc}
%patch0 -p1 -b .sparc
%endif
%patch1 -p1 -b .type_conflict
%patch2 -p1 -b .umode_t
%patch3 -p0 -b .LDFLAGS

find . -name CVS -type d | xargs rm -rf

# prevent stripping (for debuginfo):
sed -i -e 's|755 --strip|755|g' Makefile

%build
%make CFLAGS="%{optflags} -O3 -fno-strength-reduce -Wall" LDFLAGS=""

%install
mkdir -p %{buildroot}{%{_sbindir},%{_bindir},%{_mandir}/man8}

%makeinstall_std \
	BINDIR=%{buildroot}%{_sbindir} \
	ALTBIN=%{buildroot}%{_bindir} \
	MANDIR=%{buildroot}%{_mandir}/man8

ln -sf %{_sbindir}/taper %{buildroot}%{_bindir}/taper
ln -sf %{_sbindir}/bg_restore %{buildroot}%{_bindir}/bg_restore
ln -sf %{_sbindir}/bg_backup %{buildroot}%{_bindir}/bg_backup

%files
%doc docs/*
%{_bindir}/*
%{_sbindir}/*
%{_mandir}/man8/taper.8*


%changelog
