Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?tcl_version: %global tcl_version %((echo '8.6'; echo 'puts $tcl_version' | tclsh 2>/dev/null) | tail -1)}
%{!?tcl_sitearch: %global tcl_sitearch %{_libdir}/tcl%{tcl_version}}

%define real_name mysqltcl

Summary:        MySQL interface for Tcl
Name:           tcl-mysqltcl
Version:        3.052
Release:        alt2_22

License:        MIT
Source:         http://www.xdobry.de/mysqltcl/%{real_name}-%{version}.tar.gz
URL:            http://www.xdobry.de/mysqltcl

BuildRequires:  gcc
BuildRequires:  libmariadb-devel
BuildRequires:  tcl-devel
Provides:       %{real_name} = %{version}-%{release}
Source44: import.info

%description
Mysqltcl is an extension to the Tool Command Language (Tcl) that
provides high-level access to a MySQL database server.


%prep
%setup -q -n mysqltcl-%{version}
chmod -x generic/mysqltcl.c
chmod 644 README ChangeLog COPYING AUTHORS README-msqltcl doc/mysqltcl.html

%build
%configure --with-tcl=%{_libdir} \
           --with-mysql-lib=%{_libdir} \
           --enable-threads \
           --enable-symbols
%make_build


%install
rm -Rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT%{tcl_sitearch}
mv $RPM_BUILD_ROOT%{_libdir}/%{real_name}-%{version} $RPM_BUILD_ROOT%{tcl_sitearch}/%{real_name}-%{version}


%files
%doc README ChangeLog COPYING AUTHORS README-msqltcl doc/mysqltcl.html
%{tcl_sitearch}/%{real_name}-%{version}
%{_mandir}/mann/*


%changelog
