# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
%{!?_texmf: %define _texmf %(eval "echo `kpsewhich -expand-var '$TEXMFMAIN'`")}

%define texpkg      IEEEtran
%define texpkgdir   %{_texmf}/tex/latex/%{texpkg}
%define texpkgdoc   %{_texmf}/doc/latex/%{texpkg}
%define bibpkgdir   %{_texmf}/bibtex/bib/%{texpkg}
%define bstpkgdir   %{_texmf}/bibtex/bst/%{texpkg}
%define bibpkgdoc   %{_texmf}/doc/bibtex/%{texpkg}

Name:           tetex-%{texpkg}
Version:        1.7.1
Release:        alt1_8
Summary:        Official LaTeX class for IEEE transactions journals and conferences

Group:          Publishing
License:        LPPL
URL:            http://www.ctan.org/tex-archive/help/Catalogue/entries/ieeetran.html
Source0:        ftp://ctan.org/tex-archive/macros/latex/contrib/IEEEtran.zip
BuildArch:      noarch

BuildRequires: /usr/bin/latex texlive-latex-recommended
Requires: /usr/bin/latex texlive-latex-recommended
Requires(post): /usr/bin/texhash
Requires(postun): /usr/bin/texhash
Source44: import.info

%description
The IEEEtran class is the official LaTeX class for authors of the
Institute of Electrical and Electronics Engineers (IEEE) transactions
journals and conferences. 

%prep
%setup -q -n %{texpkg}
mv bibtex/README README_BIBTEX
mv tools/README README_TOOLS

%build

%install

install -d -m 755 $RPM_BUILD_ROOT{%{texpkgdir},%{texpkgdoc}}
install -p -m 644 IEEEtran.cls $RPM_BUILD_ROOT%{texpkgdir}/
install -p -m 644 tools/IEEEtrantools.sty $RPM_BUILD_ROOT%{texpkgdir}/
install -p -m 644 IEEEtran_HOWTO.pdf $RPM_BUILD_ROOT%{texpkgdoc}/
install -p -m 644 tools/IEEEtrantools_doc.txt $RPM_BUILD_ROOT%{texpkgdoc}/

install -d -m 755 $RPM_BUILD_ROOT{%{bibpkgdir},%{bstpkgdir},%{bibpkgdoc}}
install -p -m 644 bibtex/*.bib $RPM_BUILD_ROOT%{bibpkgdir}/
install -p -m 644 bibtex/*.bst $RPM_BUILD_ROOT%{bstpkgdir}/
install -p -m 644 bibtex/IEEEtran_bst_HOWTO.pdf $RPM_BUILD_ROOT%{bibpkgdoc}/

%triggerin -- lyx
if [ $2 -gt 1 ]; then
cd %{_datadir}/lyx && \
  ./configure --without-latex-config > /dev/null 2>&1 ||:
fi

%triggerun -- lyx
if [ $2 -eq 0 ]; then
cd %{_datadir}/lyx && \
  ./configure --without-latex-config > /dev/null 2>&1 ||:
fi


%files
%doc README README_BIBTEX README_TOOLS bare_conf.tex bare_jrnl.tex 
%doc extras/tux.eps
%doc changelog.txt
%{texpkgdir}/
%{texpkgdoc}/
%{bibpkgdir}/
%{bstpkgdir}/
%{bibpkgdoc}/


%changelog
