Group: Publishing
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name tetex-elsevier
%define version 0.1.20090917
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}
%define texmflocal   %(kpsewhich -var-value TEXMFLOCAL)

Name:           tetex-elsevier
# upstream is unversioned, the version is constructed with the latest 
# file timestamp, in the format YYYYMMDD
Version:        0.1.20090917
Release:        alt1_26
Summary:        Elsevier LaTeX style files and documentation

License:        LPPL
URL:            http://www.elsevier.com/locate/latex
# Put this one as Source0 so it's easy to uncompress
Source1:        http://www.elsevier.com/framework_authors/misc/elsart.cls
Source2:        http://www.elsevier.com/framework_authors/misc/elsart1p.cls
Source3:        http://www.elsevier.com/framework_authors/misc/elsart3p.cls
Source4:        http://www.elsevier.com/framework_authors/misc/elsart5p.cls
Source7:        http://www.elsevier.com/framework_authors/misc/template-harv.tex
Source8:        http://www.elsevier.com/framework_authors/misc/template-num.tex
Source9:        http://www.elsevier.com/framework_authors/misc/elsart-harv.bst
Source10:       http://www.elsevier.com/framework_authors/misc/elsart-num.bst
Source11:       http://www.elsevier.com/framework_authors/misc/elsart-num-names.bst
Source12:       http://www.elsevier.com/framework_authors/misc/elsart-num-sort.bst
Source13:       http://www.elsevier.com/framework_authors/misc/CHANGES
Source14:       http://www.elsevier.com/framework_authors/misc/README
Source15:       http://www.elsevier.com/framework_authors/misc/instructions-num.tex
Source16:       http://www.elsevier.com/framework_authors/misc/instructions-harv.tex
Source18:       README.package

Buildarch:      noarch
BuildRequires:  tex(latex)
BuildRequires:  tex(lineno.sty)

Requires:       tex(latex)

Requires(post): tex(tex)
Requires(postun): tex(tex)
Source44: import.info

%description
LaTeX style files and documentation for the Elsevier publisher, legacy files.
See texlive-elsarticle for elsarticle.

%prep
%setup -q -c -T
cp -p %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} \
 %{SOURCE7} %{SOURCE8} %{SOURCE9} %{SOURCE10} %{SOURCE11} %{SOURCE12} \
 %{SOURCE13} %{SOURCE14} %{SOURCE15} %{SOURCE16} %{SOURCE18} .

# remove dos end of lines and keep timestamps
for file in CHANGES *.cls *.bst *.tex; do
  sed -e 's/\r//' $file > $file.tmp
  touch -r $file $file.tmp
  mv $file.tmp $file
done

%build
pdflatex instructions-num
pdflatex instructions-num
pdflatex instructions-harv
pdflatex instructions-harv


%install
install -d -m755 $RPM_BUILD_ROOT%{texmflocal}/tex/latex/elsevier/
install -d -m755 $RPM_BUILD_ROOT%{texmflocal}/bibtex/bst/elsevier/
cp -p *.cls $RPM_BUILD_ROOT%{texmflocal}/tex/latex/elsevier/
cp -p *.bst $RPM_BUILD_ROOT%{texmflocal}/bibtex/bst/elsevier/

# Link .pdf files into texmflocal tree for texdoc
install -d -m755 $RPM_BUILD_ROOT%{texmflocal}/doc/latex/elsevier
for file in *.pdf; do
    ln -s %{_docdir}/%{name}-%version/$file $RPM_BUILD_ROOT%{texmflocal}/doc/latex/elsevier
done


%post
mktexlsr %{texmflocal} >/dev/null 2>&1 || :


%postun
mktexlsr %{texmflocal} >/dev/null 2>&1 || :


%files
%doc README README.package CHANGES *.pdf template-*.tex
%{texmflocal}/tex/latex/elsevier/
%{texmflocal}/bibtex/bst/elsevier/
%{texmflocal}/doc/latex/elsevier/


%changelog
