# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-texmf
# END SourceDeps(oneline)
Name:		tex-zfuzz
Version:	3.4.1
Release:	alt1_9
Summary:	Type-checker and LaTeX style for Z spec language
Group:		Engineering
License:	BSD
URL:		http://spivey.oriel.ox.ac.uk/mike/fuzz/
Source0:	http://spivey.oriel.ox.ac.uk/mike/fuzz/fuzz-%{version}.tgz
Source1:	http://spivey.oriel.ox.ac.uk/mike/fuzz/fuzzman.pdf
Source2:	http://spivey.oriel.ox.ac.uk/mike/fuzz/refcard.pdf
Source3:	http://spivey.oriel.ox.ac.uk/mike/fuzz/fuzzman-2up.pdf
Source4:	http://spivey.oriel.ox.ac.uk/mike/fuzz/refcard-2up.pdf
Source5:	http://spivey.oriel.ox.ac.uk/mike/fuzz/refcard-3up.pdf
# Add DESTDIR support to the makefile
Patch0 :	tex-zfuzz-20070911-destdir.patch
# Remove a superfluous (and wrong) prototype, and don't generate the unused
# input() and unput() functions
Patch1:		tex-zfuzz-3.4.1-zscan.patch

Requires: /usr/bin/latex texlive-latex-recommended
BuildRequires: /usr/bin/latex texlive-latex-recommended, bison, flex
Requires(post): /usr/bin/tex texlive-generic-recommended
Requires(postun): /usr/bin/tex texlive-generic-recommended

# Ubuntu and Debian have a different package named "fuzz", which is
# better-known and Fedora may include someday, so the command is renamed as
# "zfuzz" per upstream (Mike Spivey) recommendation.  The package is named
# "tex-zfuzz", to follow Fedora naming conventions for TeX packages. The
# LaTeX style is still "fuzz", preserving an upstream request: "please don't
# rename the LaTeX style option, or existing documents will break."

# The package contains a few glyphs, but creating a separate font
# subpackage seemed unnecessary and confusing (it's the only package using
# them). Thus, it's been packaged as a single package, as upstream does.
# The LaTeX style and type-checker COULD be separately packaged, but that also
# seems pointless; they are intended to be used together.

# Dirs for LaTeX styles, metafont, .tfm (root/specific), *pk (root/specific):
%global _texmf_main %{_datadir}/texmf
%global texdir	%{_texmfmain}/tex/latex/%{name}
%global mfdir	%{_texmfmain}/metafont/%{name}
%global tfmdirr	%{_texmfmain}/fonts/tfm/%{name}
%global pkdirr	%{_texmfmain}/fonts/pk/%{name}
%global tfmdir	%{tfmdirr}/oxsz
%global pkdir	%{pkdirr}/oxsz
Source44: import.info

%description
This package (formerly named "fuzz") is a collection of tools that help
you to:
(1) format and print good-looking specifications in the Z ("zed") formal
    specification language using LaTeX (through a new LaTeX style), and
(2) check them for compliance with the Z scope and type rules.  It
    includes a few font definitions for Za.'s special symbols.

This package is useful if you want to create formal specifications using
the Z specification language.  The Z language accepted is that of the Z
Reference Manual, second edition, which is not exactly the same as the Z
ISO standard (see http://www.cs.york.ac.uk/hise/cadiz/standard.html for
the differences).

Historically, this package was called "fuzz", but there is another
program ALSO called fuzz, so the command-line type-checker's has been
changed to "zfuzz".  The LaTeX style itself is still named "fuzz" (so
LaTeX documents will keep working).

%prep
%setup -q -n fuzz-%{version}
%patch0
%patch1

# The source for some documents are in ./doc as LaTeX, but as upstream says:
# "The fuzz manual and reference card are written with LaTeX 2.09.
# Good luck unearthing a copy of that if you want to reformat it."
cp -p %SOURCE1 .
cp -p %SOURCE2 .
cp -p %SOURCE3 .
cp -p %SOURCE4 .
cp -p %SOURCE5 .

# Fix the default path
sed -i 's!/usr/local/lib/!%{_datadir}/%{name}/!g' src/param.c

%build
# The "lib" is really shared data, so we'll put it in %%_datadir (/usr/share)
# instead of /usr/lib to meet the File Hierarchy Standard (FHS).
make %{?_smp_mflags} CFLAGS="%{optflags}" \
 BINDIR=%{_bindir} LIBDIR=%{_datadir}/%{name} \
 TEXDIR=%{texdir} MFDIR=%{mfdir}

# Generate docs and pregenerated .tfm/*pk files:
pushd tex
 for file in oxsz[1-9]*.mf
 do
  mktextfm --destdir `pwd` `basename $file .mf`
 done
 mktexpk --destdir `pwd` --mfmode / --bdpi 600 --mag 1+120/600 --dpi 720 oxsz10
 pdflatex example.tex
 # Run latex twice on the tutorial (to get the cross-references correct):
 pdflatex tut.tex
 pdflatex tut.tex
 mv example.tex example.pdf tut.pdf ..
popd

%check
make test

%install
install -d %{buildroot}%{_bindir}
install -d %{buildroot}%{_datadir}/%{name}
install -d %{buildroot}%{texdir}
install -d %{buildroot}%{mfdir}
install -d %{buildroot}%{tfmdir}
install -d %{buildroot}%{pkdir}

make install DESTDIR=%{buildroot} \
 BINDIR=%{_bindir} LIBDIR=%{_datadir}/%{name} \
 TEXDIR=%{texdir} MFDIR=%{mfdir} INSTALL="install -p"

(cd %{buildroot}%{_bindir} ; mv fuzz zfuzz)

# Install pre-built .tfm and *pk files (speeds use):
cp -p tex/*.tfm %{buildroot}%{tfmdir}
cp -p tex/*pk %{buildroot}%{pkdir}

# The "INSTALL" file includes the license text, so install as doc.
# TeX file installation follows the "info tds" rules of texlive-texmf.

%files
%{_bindir}/*
%{_datadir}/%{name}/
%{texdir}/
%{mfdir}/
%{tfmdirr}/
%{pkdirr}/
%doc INSTALL
%doc fuzzman.pdf
%doc refcard.pdf
%doc fuzzman-2up.pdf
%doc refcard-2up.pdf
%doc refcard-3up.pdf
%doc example.tex
%doc example.pdf
%doc tut.pdf

%post
mktexlsr >/dev/null 2>&1 || :

%postun
mktexlsr >/dev/null 2>&1 || :

%changelog
