Epoch: 0
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          tggraphlayout
Version:       1.22
Release:       alt1_8
Summary:       The layout library of the Touchgraph project
Group:         Development/Java
License:       ASL
URL:           http://www.touchgraph.com/
Source0:       http://sourceforge.net/projects/touchgraph/files/GraphLayout/1.22-jre11/TGGL_122_jre11.zip
Patch0:        tggraphlayout-javadoc.patch
BuildRequires: java-devel-default /proc
BuildRequires: javapackages-tools
Requires:      javapackages-tools
BuildArch:     noarch
Source44: import.info

%description
TouchGraph provides a set of interfaces for graph visualization using
force-based layout and focus+context techniques. For now only
older code is available, but we are planning to release new versions
as well.

%package javadoc
Group:         Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
The layout library of the Touchgraph project.

This package contains javadoc for %{name}.

%prep
%setup -q -n TGGraphLayout
%patch0 -p1


for j in $(find . -name "*.jar"); do
  mv $j ${j}.no
done
for j in $(find . -name "*.class"); do
  mv $j ${j}.no
done
mv TGGL\ ReleaseNotes.txt TGGL_ReleaseNotes.txt

mkdir -p classes
mkdir -p apidocs

%build
export ClASSPATH=%Java_home/jre/lib/rt.jar
javac -d classes $(find com/ -name "*.java")
javadoc -d apidocs $(find com/ -name "*.java")
pushd classes
  jar cf ../tggraphlayout-%{version}.jar *
popd
%install
mkdir -p %{buildroot}%{_javadir}
install -pm 644 tggraphlayout-%{version}.jar \
  %{buildroot}%{_javadir}/

(
  cd %{buildroot}%{_javadir}
  for jar in *-%{version}*; do
    ln -sf ${jar} ${jar/-%{version}/}
  done
  ln -sf tggraphlayout-%{version}.jar %{buildroot}%{_javadir}/tggl.jar
)

mkdir -p %{buildroot}%{_javadocdir}/tggraphlayout-%{version}
cp -pr apidocs/* %{buildroot}%{_javadocdir}/tggraphlayout-%{version}
ln -s tggraphlayout-%{version} %{buildroot}%{_javadocdir}/tggraphlayout

%files
%{_javadir}/tggl.jar
%{_javadir}/tggraphlayout-%{version}.jar
%{_javadir}/tggraphlayout.jar
%doc TG-APACHE-LICENSE.txt TGGL_ReleaseNotes.txt TGGraphLayout.html

%files javadoc
%{_javadocdir}/tggraphlayout-%{version}
%{_javadocdir}/tggraphlayout



%changelog
