Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: perl(Socket6.pm)
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: thc-ipv6
Version: 3.8
Release: alt1_5
Summary: Toolkit for attacking the IPv6 protocol suite

License: AGPLv3 with exceptions
URL: https://github.com/vanhauser-thc/thc-ipv6
Source0: https://github.com/vanhauser-thc/thc-ipv6/archive/v%{version}/%{name}-%{version}.tar.gz
Patch0: https://github.com/vanhauser-thc/thc-ipv6/commit/5dea4ce77dbff19c53c027229365fd5aad4570d3.patch#/thc-ipv6-3.8-socket.patch

BuildRequires: gcc
BuildRequires: libpcap-devel
%if 0%{?fedora} || 0%{?rhel} >= 8
BuildRequires: libssl-devel
%else
BuildRequires: openssl11-devel
%endif
BuildRequires: libnetfilter_queue-devel
BuildRequires: rpm-build-perl
Source44: import.info

%description
A complete tool set to attack the inherent protocol weaknesses of IPv6
and ICMPv6, including an easy to use packet factory library.

%prep
%setup -q
%patch0 -p1


%build
%if 0%{?rhel} == 7
OPENSSL_CFLAGS="$(pkg-config --cflags-only-I openssl11)"
OPENSSL_LDFLAGS="$(pkg-config --libs-only-L openssl11)"
%endif

%make_build \
  CFLAGS="%{optflags} $OPENSSL_CFLAGS -D_HAVE_SSL" \
  LDFLAGS="%{?__global_ldflags} $OPENSSL_LDFLAGS -lpcap -lssl -lcrypto"

%install
%makeinstall_std \
  PREFIX=%{_prefix} \
  STRIP=%{_bindir}/true

%files
%doc --no-dereference LICENSE LICENSE.OPENSSL
%doc CHANGES HOWTO-INJECT README
%{_bindir}/*
%{_mandir}/man8/*

%changelog
