BuildRequires: chrpath
Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install imake libXt-devel xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           tkgate
Version:        2.0
Release:        alt3_39.beta10
Summary:        An event driven digital circuit simulator

License:        GPLv2+
URL:            http://www.tkgate.org/

Patch0:         tkgate-2.0-doc.patch
Patch1:         tkgate-2.0-lm.patch
# From debian wheezy
Patch2:         tkgate-2.0-typos.patch
# From debian wheezy
Patch3:         tkgate-2.0-hardening.patch

Source0:        http://www.tkgate.org/downloads/%{name}-%{version}-b10.tgz

%{?el5:BuildRoot:      %{_var}/tmp/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)}

# el5/el6 have been shipped with vendor prefixed desktop files
# We must continue to do so until EOL of these distros.
%{?el5:%global vendor_desktop 1}
%{?el6:%global vendor_desktop 1}

BuildRequires:  gcc-c++
BuildRequires:  tk-devel tcl-devel libICE-devel libSM-devel
BuildRequires:  desktop-file-utils
Source44: import.info


%description
TkGate is a event driven digital circuit simulator
based on Verilog. TkGate
supports a wide range of primitive circuit elements as
well as user-defined modules for hierarchical design.

%package ca
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description ca
This package contains the Catalan locales and examples for tkgate, 
Digital Circuit Simulator

%package cs
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description cs
This package contains the Czech locales and examples for tkgate, 
Digital Circuit Simulator

%package cy
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description cy
This package contains the Welsh locales and examples for tkgate, 
Digital Circuit Simulator

%package de
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description de
This package contains the German locales and examples for tkgate, 
Digital Circuit Simulator

%package es
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description es
This package contains the Spanish locales and examples for tkgate, 
Digital Circuit Simulator

%package fr
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description fr
This package contains the French locales and examples for tkgate, 
Digital Circuit Simulator

%package it
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description it
This package contains the Italian locales and examples for tkgate, 
Digital Circuit Simulator


%package ja
Group: Documentation
Summary:           Locales and examples for tkgate, Digital Circuit Simulator
Requires:          %{name} = %{version}-%{release}
%{?!el5:BuildArch:         noarch}

%description ja
This package contains the Japanese locales and examples for tkgate, 
Digital Circuit Simulator


%prep
%setup -q -n %{name}-%{version}-b10

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

# propagate paths to sources
sed -i "s|\"\${tkg_gateHome}/libexec/verga\"|\"%{_bindir}/verga\"|" scripts/parms.tcl
sed -i "s|\"%s/libexec/tkgate\",TkGate\.homedir|\"%{_bindir}/tkgate\"|" src/tkgate/verilog_out.c

sed -i "s|license.txt||" scripts/license.tcl
sed -i "s|TKGATE_LIBDIRS=\"\(.*\)\"|TKGATE_LIBDIRS=\"\1 %{_libdir}\"|" configure
# E: backup-file-in-package
find . -type f -name "*~" -exec rm -f  {} ';'
find . -type f -name "\#*\#" -exec rm -f  {} ';'
find . -type f \( -name "*.bak" -o -name "*.orig" -o -name "*.old" -o -name "*.orig2" \) -delete
find . -type f -name orig-messages -delete

# spurious-executable-perm
chmod 0755 scripts/tree.tcl
chmod 0644 test/verga/maketests.sh
chmod 0644 test/verga/runtests.sh

# E: zero-length
rm -f locale/{en,ja}/tutorials/definition.txt
rm -f bindings/none
rm -f scripts/dip.tcl
rm -f test/verga/grammar.out


cat > %{name}.desktop << EOF
[Desktop Entry]
Encoding=UTF-8
Name=Digital circuit simulator
GenericName=Verilog circuit simulator
Comment=TkGate
Type=Application
Exec=tkgate
Icon=tkgate
Categories=Engineering;Electronics;
EOF


%build
CFLAGS="%{optflags} -DUSE_INTERP_RESULT -std=gnu89"
%configure
make %{?_smp_mflags} 


%install
%{?el5:rm -rf %{buildroot}}
make INSTALL="install -p" install DESTDIR=%{buildroot}

# Symlink points to BuildRoot:
rm -rf %{buildroot}%{_datadir}/%{name}/libexec/


# desktop file and its icon
desktop-file-install %{?vendor_desktop:--vendor fedora} \
    --dir %{buildroot}%{_datadir}/applications \
    %{name}.desktop

install -d %{buildroot}%{_datadir}/pixmaps/
install -pm 0644 images/run01.gif %{buildroot}%{_datadir}/pixmaps/%{name}.png
cp -p site-preferences %{buildroot}%{_datadir}/%{name}/site-preferences
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin,/usr/games} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done

%files ca
%{_datadir}/%{name}/locale/ca/*

%files cs
%{_datadir}/%{name}/locale/cs/*

%files cy
%{_datadir}/%{name}/locale/cy/*

%files de
%{_datadir}/%{name}/locale/de/*

%files es
%{_datadir}/%{name}/locale/es/*

%files fr
%{_datadir}/%{name}/locale/fr/*

%files it
%{_datadir}/%{name}/locale/it/*

%files ja
%{_datadir}/%{name}/locale/ja/*


%files
%doc README README.verga COPYING
%doc license.txt pkg-comment pkg-descr TODO
%doc doc/ test/
%{_bindir}/gmac
%{_bindir}/%{name}
%{_bindir}/verga
%{_datadir}/%{name}
%{_mandir}/man1/gmac.1*
%{_mandir}/man1/tkgate.1*
%{_mandir}/man1/verga.1*
%{_datadir}/applications/%{?vendor_desktop:fedora-}%{name}.desktop
%{_datadir}/pixmaps/%{name}.png
%exclude %{_datadir}/%{name}/locale/ca
%exclude %{_datadir}/%{name}/locale/cs
%exclude %{_datadir}/%{name}/locale/cy
%exclude %{_datadir}/%{name}/locale/de
%exclude %{_datadir}/%{name}/locale/es
%exclude %{_datadir}/%{name}/locale/fr
%exclude %{_datadir}/%{name}/locale/it
%exclude %{_datadir}/%{name}/locale/ja

%changelog
