Group: Text tools
# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(glib-2.0)
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Building the Enchant Voikko provider is disabled by default because it should
# be included in Enchant 1.4.
# Pass '--with enchant' on rpmbuild command-line to enable it.
%bcond_with enchant

Name:           tmispell-voikko
Version:        0.7.1
Release:        alt3_34
Summary:        An Ispell compatible front-end for spell-checking modules

License:        GPLv2+
URL:            https://voikko.puimula.org/
Source0:        https://www.puimula.org/voikko-sources/%{name}/%{name}-%{version}.tar.gz
Source1:        https://www.puimula.org/voikko-sources/%{name}/%{name}-%{version}.tar.gz.asc
# Keyring created by running
# gpg2 --export --export-options export-minimal "AC5D 65F1 0C85 96D7 E2DA E263 3D30 9B60 4AE3 942E" > gpgkey-AC5D65F10C8596D7E2DAE2633D309B604AE3942E.gpg
# See https://voikko.puimula.org/sources.html
Source2:        gpgkey-AC5D65F10C8596D7E2DAE2633D309B604AE3942E.gpg
Patch0:         tmispell-voikko-0.7.1-glib-2.31-fix.patch
Patch1:         0001-redraw_minimenu-add-format-string.patch

BuildRequires:  gcc-c++
BuildRequires:  gnupg2
BuildRequires:  libvoikko-devel libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel gettext-tools libglibmm-devel
%if %{with enchant}
BuildRequires: libenchant-devel
%endif
Source44: import.info

%description
Tmispell is an Ispell compatible front-end for spell-checking
modules. To do the actual spell-checking for Finnish language it uses
the spell-checking system Voikko.

%package -n 	enchant-voikko
Group: System/Libraries
Summary:        Voikko spellchecker support for Enchant


%description -n enchant-voikko
Voikko spellchecker support for Enchant.

# TODO: /usr/bin/ispell should be a symlink to /usr/bin/tmispell and the real
# ispell should be renamed to e.g. /usr/bin/ispell.real for KDE etc. to work.
# The other option would be to modify /usr/bin/ispell to call
# /usr/bin/tmispell when it's called with Finnish. If neither of these can be
# done, it's worth it to have /usr/bin/tmispell as a command line client for
# Voikko.

%prep
%setup -q
%patch0 -p1
%patch1 -p1


%build
%if %{with enchant}
%configure --disable-dependency-tracking
%else
%configure --disable-dependency-tracking --disable-enchant
%endif

%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
%if %{with enchant}
# Remove static archive
find $RPM_BUILD_ROOT -name '*.a' -exec rm -f {} ';'
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'
# Remove the symlinks and move the library itself into a better name
rm $RPM_BUILD_ROOT%{_libdir}/enchant/libenchant_voikko.so.1 \
   $RPM_BUILD_ROOT%{_libdir}/enchant/libenchant_voikko.so
mv $RPM_BUILD_ROOT%{_libdir}/enchant/libenchant_voikko.so.* \
   $RPM_BUILD_ROOT%{_libdir}/enchant/libenchant_voikko.so
%endif
# Install the configuration file
sed -i -e 's/ispell.real/ispell/' tmispell.conf.example
install -Dpm 0644 tmispell.conf.example $RPM_BUILD_ROOT%{_sysconfdir}/tmispell.conf
# Fake Finnish dictionary for ispell clients. Commented out for now.
# These won't actually work for KDE etc. unless the binary is in
# /usr/bin/ispell (or /usr/bin/ispell calls tmispell). These files should always 
# be installed into %{_prefix}/lib/ispell/ even though it's an rpmlint error
# because my testing shows that KDE recognizes them from there but not from 
# /usr/share.
#install -dm 755 %{buildroot}%{_prefix}/lib/ispell
#touch %{buildroot}%{_prefix}/lib/ispell/suomi.{hash,aff}
%find_lang %{name}



%files -f %{name}.lang
%doc AUTHORS ChangeLog COPYING NEWS README README.fi
%config(noreplace) %{_sysconfdir}/tmispell.conf
%{_mandir}/man1/tmispell*
%{_mandir}/man5/tmispell*
%{_bindir}/tmispell
# Fake dictionary directory, commented out for now
#%{_prefix}/lib/ispell

%if %{with enchant}
%files -n enchant-voikko
%{_libdir}/enchant/libenchant_voikko.so
%endif


%changelog
