Group: System/Base
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define		path_to_vi /bin/vi
%define		path_to_sendmail /usr/sbin/sendmail

Name:		tripwire
Version:	2.4.3.7
Release:	alt2_17
Summary:	IDS (Intrusion Detection System)

License:	GPL-2.0-or-later
Source0:	https://github.com/Tripwire/%{name}-open-source/releases/download/%{version}/%{name}-open-source-%{version}.tar.gz
Source1:	tripwire.cron.in
Source3:	tripwire.gif
Source4:	twcfg.txt.in
Source5:	tripwire-setup-keyfiles.in
Source6:	twpol.txt.in
Source7:	README.Fedora.in
Source9:	License-Issues
URL:		https://github.com/Tripwire/%{name}-open-source/

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:	libssl-devel
Requires(post):	sed
Source44: import.info


%description
Tripwire is a very valuable security tool for Linux systems, if  it  is
installed to a clean system. Tripwire should be installed  right  after
the OS installation, and before you have connected  your  system  to  a
network (i.e., before any possibility exists that someone  could  alter
files on your system).

When Tripwire is initially set up, it creates a database  that  records
certain file information. Then when it is run, it compares a designated
set of files and directories to the information stored in the database.
Added or deleted files are flagged and reported, as are any files  that
have changed from their previously recorded state in the database. When
Tripwire is run against system files  on  a  regular  basis,  any  file
changes will be spotted when Tripwire is run. Tripwire will report  the
changes, which will give system administrators a clue that they need to
enact damage control measures immediately if certain  files  have  been
altered.

%prep
%setup -q -n %{name}-open-source-%{version}
cp -p %{SOURCE3} .

%build
export CXXFLAGS="-std=c++14 $RPM_OPT_FLAGS"
%configure --sysconfdir=%{_sysconfdir}/tripwire \
           path_to_vi=%{path_to_vi} \
           path_to_sendmail=%{path_to_sendmail}

make %{?_smp_mflags}

%install
rm -fr %{buildroot}

# Install the binaries.
mkdir -p %{buildroot}%{_sbindir}
install -p -m755 bin/siggen %{buildroot}%{_sbindir}
install -p -m755 bin/tripwire %{buildroot}%{_sbindir}
install -p -m755 bin/twadmin %{buildroot}%{_sbindir}
install -p -m755 bin/twprint %{buildroot}%{_sbindir}

# Install the man pages.
mkdir -p %{buildroot}%{_mandir}/{man4,man5,man8}
install -p -m644 man/man4/*.4 %{buildroot}%{_mandir}/man4/
install -p -m644 man/man5/*.5 %{buildroot}%{_mandir}/man5/
install -p -m644 man/man8/*.8 %{buildroot}%{_mandir}/man8/

# Create configuration files from templates.
rm -fr _tmpcfg
mkdir _tmpcfg
for infile in %{SOURCE1} %{SOURCE4} %{SOURCE5} %{SOURCE6} %{SOURCE7} ; do
	outfile=${infile##/*/}
	outfile=${outfile%.*n}
	cat ${infile} |\
	sed -e 's|@path_to_vi@|%{path_to_vi}|g' |\
	sed -e 's|@path_to_sendmail@|%{path_to_sendmail}|g' |\
	sed -e 's|@sysconfdir@|%{_sysconfdir}|g' |\
	sed -e 's|@sbindir@|%{_sbindir}|g' |\
	sed -e 's|@vardir@|%{_var}|g' >\
	_tmpcfg/${outfile}
done
mv _tmpcfg/{tripwire-setup-keyfiles,README.Fedora} .

# Create the reports directory.
install -d -m700 %{buildroot}%{_var}/lib/tripwire/report

# Install the cron job.
install -d -m755 %{buildroot}%{_sysconfdir}/cron.daily
install -p -m755 _tmpcfg/tripwire.cron \
	%{buildroot}%{_sysconfdir}/cron.daily/tripwire-check
rm _tmpcfg/tripwire.cron

# Install configuration files.
mkdir -p %{buildroot}%{_sysconfdir}/tripwire
for file in _tmpcfg/* ; do
	install -p -m644 ${file} %{buildroot}%{_sysconfdir}/tripwire
done

# Install the keyfile setup script
install -p -m755 tripwire-setup-keyfiles %{buildroot}%{_sbindir}

# Fix permissions on documentation files.
cp -p %{SOURCE9} .
chmod 644 \
	ChangeLog COMMERCIAL COPYING TRADEMARK tripwire.gif \
	README.Fedora policy/policyguide.txt License-Issues


%post
%{__sed} -i -e "s|localhost|$HOSTNAME|g" %{_sysconfdir}/tripwire/twpol.txt


%files
%doc ChangeLog COMMERCIAL COPYING TRADEMARK tripwire.gif
%doc README.Fedora policy/policyguide.txt License-Issues
%attr(0700,root,root) %dir %{_sysconfdir}/tripwire
%config(noreplace) %{_sysconfdir}/tripwire/twcfg.txt
%config(noreplace) %{_sysconfdir}/tripwire/twpol.txt
%attr(0755,root,root) %{_sysconfdir}/cron.daily/tripwire-check
%attr(0700,root,root) %dir %{_var}/lib/tripwire
%attr(0700,root,root) %dir %{_var}/lib/tripwire/report
%{_mandir}/*/*
%attr(0755,root,root) %{_sbindir}/*


%changelog
