#tmp hack
ExcludeArch: %{ix86}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		turtlearena
Summary:	A Third Person Action game using a modified version of the ioquake3 engine
Version:	0.6.1
Release:	alt1_12
License:	GPLv2+
Group:		Games/Other
URL:		https://clover.moe/turtlearena/
Source0:	http://turtlearena.googlecode.com/files/%{name}-%{version}-0-src.tar.bz2
# From openarena-engine
# https://github.com/pelya/openarena-engine/commit/e1c5a8f700ddda51d2a0dc4d289c02dd21a0bee5
Patch0:		0001-Added-ARM64-support.patch
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(sdl)
BuildRequires:	pkgconfig(theora)
BuildRequires:	pkgconfig(vorbis)
BuildRequires:	pkgconfig(glu)
BuildRequires:	ImageMagick-tools
Requires:	%{name}-data => %{version}
Source44: import.info

%description
Turtle Arena (working title) is a free and open source cross-platform
third-person action game using a modified version of the ioquake3 engine.
Turtle Arena is currently focused on multiplayer (with multiple game modes)
and can be played with human players over a network, split-screen, or with AI
players. In the future there will also be a single player / cooperative reach
the end of the level mode with AI enemies.

The game is currently in the process of changing from "Turtle Arena" to
"Extraordinary Beat X."

%files
%{_bindir}/%{name}
%{_bindir}/%{name}.real
%{_iconsdir}/hicolor/*/apps/%{name}.png
%{_datadir}/applications/%{name}.desktop

#----------------------------------------------------------------

%package server
Group:		Games/Other
Summary:	Dedicated server for TurtleArena
Requires:	%{name}-data => %{version}

%description server
Turtle Arena (working title) is a free and open source cross-platform 
third-person action game using a modified version of the ioquake3 engine.
Turtle Arena is currently focused on multiplayer (with multiple game modes) 
and can be played with human players over a network, split-screen, or with AI 
players. In the future there will also be a single player / cooperative reach 
the end of the level mode with AI enemies.

This package contains the dedicated server for Turtle Arena.

%files server
%{_bindir}/%{name}-server

#----------------------------------------------------------------

%prep
%setup -q -n %{name}-%{version}-0-src

pushd engine
%patch0 -p1
popd

%build
%add_optflags %optflags_shared
#The setup_compile_flags macro commented because it breaks the build, somehow
#makes the build don't find math lib which is part of linker flags of the game
#%%set_build_flags

#The serverbuild macro commented because makes the game freeze at loading
#%%serverbuild
%make_build -C engine CFLAGS="%{optflags}"

%install
mkdir -p %{buildroot}%{_bindir}
install -m 755 engine/build/release-linux-*/%{name}.* \
  %{buildroot}%{_bindir}/%{name}.real
install -m 755 engine/build/release-linux-*/%{name}-server.* \
  %{buildroot}%{_bindir}/%{name}-server

install -d %{buildroot}%{_bindir}
cat > %{buildroot}%{_bindir}/%{name} <<EOF
#!/bin/sh
exec %{_bindir}/%{name}.real +set com_basegame base +set com_homepath .%{name} +set fs_basepath %{_datadir}/%{name}-data
EOF
chmod 755 %{buildroot}%{_bindir}/%{name}

mkdir -p %{buildroot}%{_iconsdir}/hicolor/{16x16,32x32,48x48,64x64,128x128}/apps
convert -scale 64x64 debian_main/engine/debian/turtlearena128.png %{buildroot}%{_iconsdir}/hicolor/64x64/apps/%{name}.png
convert -scale 48x48 debian_main/engine/debian/turtlearena128.png %{buildroot}%{_iconsdir}/hicolor/48x48/apps/%{name}.png
convert -scale 32x32 debian_main/engine/debian/turtlearena128.png %{buildroot}%{_iconsdir}/hicolor/32x32/apps/%{name}.png
convert -scale 16x16 debian_main/engine/debian/turtlearena128.png %{buildroot}%{_iconsdir}/hicolor/16x16/apps/%{name}.png

install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=TurtleArena
Comment=Quake 3: Arena-like Third Person Action Game
Exec=%{_bindir}/%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;ArcadeGame;
EOF


%changelog
