Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install libXpm-devel pkgconfig(xt)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# https://gcc.gnu.org/gcc-10/porting_to.html#common
%add_optflags -fcommon

Name:		twlog
Version:	3.4
Release:	alt2_10
Summary:	Records basic ham radio log information
License:	GPLv2+

URL:		http://wa0eir.bcts.info/twlog.html

Source0:	http://wa0eir.bcts.info/src/%{name}-%{version}.src.tar.gz
# Wrapper script to install user defaults
Source1:	%{name}.sh.in

# .desktop patch
Patch0:		%{name}-%{version}.desktop.patch
Patch1:		twlog-configure-c99.patch

BuildRequires:	desktop-file-utils
BuildRequires:  gcc
BuildRequires:	libXbae-devel
Source44: import.info

%description
Twlog records basic Ham log information. It was written
for day to day logging, not contesting. There are no dupe
checks or contest related features.


%prep
%setup -q
%patch0 -p1
%patch1 -p1


# Set perms on source file
chmod 644 ./src/adif.c

%build
%configure
%make_build


%install
%makeinstall_std

# Install provided icon
mkdir -p %{buildroot}/%{_datadir}/pixmaps/
install -p -D -m 0644 ./src/icons/%{name}.png %{buildroot}/%{_datadir}/pixmaps/%{name}.png

desktop-file-install \
	--dir=%{buildroot}%{_datadir}/applications/	\
	%{buildroot}/%{_datadir}/applications/%{name}.desktop

# Move original binary to libexecdir
mkdir -p %{buildroot}/%{_libexecdir}/
mv %{buildroot}/%{_bindir}/%{name} %{buildroot}/%{_libexecdir}/%{name}-bin

# Install wrapper script installs needed files in users home directory.
install -p -D -m 0755 %{SOURCE1} %{buildroot}/%{_bindir}/%{name}

# Twlog default settings
mkdir -p %{buildroot}/%{_x11appconfdir}/
install -p -D -m 0644 ./src/Twlog %{buildroot}/%{_x11appconfdir}/Twlog


%files
%doc AUTHORS NEWS README TODO ChangeLog THANKS
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_libexecdir}/%{name}-bin
%{_datadir}/pixmaps/%{name}.png
%{_x11appconfdir}/Twlog
%{_datadir}/applications/%{name}.desktop
%{_mandir}/man1/%{name}.1*

%changelog
