Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


#enable/disable tests in case the deps aren't there
%bcond_with tests

Name:           uglify-js
Version:        3.17.4
Release:        alt1_3
Summary:        JavaScript parser, mangler/compressor and beautifier toolkit
License:        BSD-2-Clause
URL:            https://github.com/mishoo/UglifyJS
Source0:        https://registry.npmjs.org/%{name}/-/%{name}-%{version}.tgz

BuildArch:      noarch

Provides:       nodejs-uglify-js = %{version}-%{release}

Provides:       uglify-js3 = %{version}-%{release}
Obsoletes:      uglify-js3 < 3.14.5-2

Provides:       nodejs-uglify-js3 = %{version}-%{release}

BuildRequires:  nodejs
BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  web-assets-devel

%if %{with tests}
BuildRequires:  npm(acorn)
BuildRequires:  npm(semver)
%endif

Requires:       js-uglify = %{version}-%{release}
Source44: import.info

%description
JavaScript parser, mangler/compressor and beautifier toolkit.

This package ships the uglifyjs command-line tool and a library suitable for
use within Node.js.

%package -n js-uglify
Group: Development/Tools
Summary:        JavaScript parser, mangler/compressor and beautifier toolkit - core library

Provides:       js-uglify3 = %{version}-%{release}
Obsoletes:      js-uglify3 < 3.14.5-2

Provides:       uglify-js-common = %{version}-%{release}
Obsoletes:      uglify-js-common < 2.2.5-4

Requires:       web-assets-filesystem

%description -n js-uglify
JavaScript parser, mangler/compressor and beautifier toolkit.

This package ships a JavaScript library suitable for use by any JavaScript
runtime.

%prep
%setup -q -n package


chmod 0755 bin/uglifyjs

%build
#nothing to do


%install
mkdir -p %{buildroot}%{_jsdir}/%{name}-3
cp -pr lib/* %{buildroot}%{_jsdir}/%{name}-3
ln -sf %{name}-3 %{buildroot}%{_jsdir}/%{name}

#compat symlink
mkdir -p %{buildroot}%{_datadir}
ln -sf javascript/%{name} %{buildroot}%{_datadir}/%{name}

mkdir -p %{buildroot}%{nodejs_sitelib}/uglify-js@3
cp -pr bin tools package.json %{buildroot}%{nodejs_sitelib}/uglify-js@3
ln -sf %{_jsdir}/%{name}-3 %{buildroot}%{nodejs_sitelib}/uglify-js@3/lib
# Fix for rpmlint.
sed -i -e 's|^#! */usr/bin/env node|#!/usr/bin/node|' \
  %{buildroot}%{nodejs_sitelib}/uglify-js@3/bin/*
chmod 755 %{buildroot}%{nodejs_sitelib}/uglify-js@3/bin/uglifyjs

mkdir -p %{buildroot}%{_bindir}
ln -sf ../lib/$(basename %{nodejs_sitelib})/uglify-js@3/bin/uglifyjs %{buildroot}%{_bindir}/uglifyjs-3
ln -sf uglifyjs-3 %{buildroot}%{_bindir}/uglifyjs

%nodejs_symlink_deps

ln -sf uglify-js@3 %{buildroot}%{nodejs_sitelib}/uglify-js
# for symlink requires
ln -s %{name} %{buildroot}%{nodejs_sitelib}/%{name}'@2'


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if %{with tests}
# Prevent timeout error on an ARM builder which is slower than the x86 builder.
sed -i '/timeout/ s/5000/10000/' test/mocha/cli.js
sed -i '/timeout/ s/10000/20000/' test/mocha/let.js
sed -i '/timeout/ s/20000/40000/' test/mocha/spidermonkey.js
NODE_DISABLE_COLORS=true %{__nodejs} test/run-tests.js
%endif


%pretrans -p <lua>
st = posix.stat("%{nodejs_sitelib}/uglify-js")
if st and st.type == "directory" then
  os.execute("rm -rf %{nodejs_sitelib}/uglify-js")
end


%pretrans -n js-uglify -p <lua>
st = posix.stat("%{_datadir}/%{name}")
if st and st.type == "directory" then
  os.execute("rm -rf %{_datadir}/%{name}")
end


%files
%{nodejs_sitelib}/uglify-js
%{nodejs_sitelib}/uglify-js@3
%{_bindir}/uglifyjs-3
%{_bindir}/uglifyjs
# for symlink requires
%{nodejs_sitelib}/%{name}@2


%files -n js-uglify
%{_jsdir}/%{name}-3
%{_jsdir}/%{name}
%{_datadir}/%{name}
%doc README.md
%doc --no-dereference LICENSE


%changelog
