Group: Development/Tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


#enable/disable tests in case the deps aren't there
%global enable_tests 0

Name:           uglify-js1
Version:        1.3.4
Release:        alt1_22
Summary:        JavaScript parser, mangler/compressor and beautifier toolkit

# BSD license in README.html
License:        BSD
URL:            https://github.com/mishoo/UglifyJS
Source0:        http://registry.npmjs.org/uglify-js/-/uglify-js-%{version}.tgz

BuildArch:      noarch
%if 0%{?fedora} >= 19 || 0%{?rhel} > 7
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  web-assets-devel

%if 0%{?enable_tests}
BuildRequires:  npm(nodeunit)
%endif

Requires: js-uglify-1 = %{version}-%{release}
Source44: import.info

%description
JavaScript parser, mangler/compressor and beautifier toolkit.  This is the
classic 1.x version of uglify-js.  Consider using the new version provided
in the uglify-js package.

This package ships the uglifyjs command-line tool and a library suitable for
use within Node.js.

%package -n js-uglify-1
Group: Development/Tools
Summary: JavaScript parser, mangler/compressor and beautifier toolkit - core library


Obsoletes: uglify-js1-common < 1.3.4-4
Provides: uglify-js1-common = %{version}-%{release}
Requires: web-assets-filesystem

%description -n js-uglify-1
JavaScript parser, mangler/compressor and beautifier toolkit.  This is the
classic 1.x version of uglify-js.  Consider using the new version provided
in the uglify-js package.

This package ships a JavaScript library suitable for use by any JavaScript
runtime.


%prep
%setup -q -n package


%build
#nothing to do


%install


mkdir -p %{buildroot}%{_jsdir}/uglify-js-1
cp -pr lib/* %{buildroot}%{_jsdir}/uglify-js-1

#compat symlink
mkdir -p %{buildroot}%{_datadir}
ln -sf javascript/uglify-js-1 %{buildroot}%{_datadir}/%{name}

mkdir -p %{buildroot}%{nodejs_sitelib}/uglify-js@1
cp -pr bin package.json uglify-js.js %{buildroot}%{nodejs_sitelib}/uglify-js@1
ln -sf %{_jsdir}/uglify-js-1 %{buildroot}%{nodejs_sitelib}/uglify-js@1/lib

##compat symlink so old modules continue to work
ln -sf uglify-js@1 %{buildroot}%{nodejs_sitelib}/%{name}

mkdir -p %{buildroot}%{_bindir}
ln -sf ../lib/node_modules/uglify-js1/bin/uglifyjs %{buildroot}%{_bindir}/uglifyjs1

#nodejs-symlink-deps is not called because this package does not have any
#dependencies and can be used outside of node


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
nodeunit test/unit/scripts.js && test/testparser.js && test/testconsolidator.js
%endif



%pre
if [ -d %{nodejs_sitelib}/uglify-js1 ]; then
  rm -rf %{nodejs_sitelib}/uglify-js1
fi

%pre -n js-uglify-1
if [ -d "%{_datadir}/%{name}" ]; then
  rm -rf %{_datadir}/%{name}
fi

%files
%{nodejs_sitelib}/uglify-js@1
%{nodejs_sitelib}/uglify-js1
%{_bindir}/uglifyjs1

%files -n js-uglify-1
%{_jsdir}/uglify-js-1
%{_datadir}/%{name}
%doc README.html README.org docstyle.css

%changelog
