# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
Summary: Decompression utility
Name: unalz
Version: 0.65
Release: alt1_8
License: zlib and BSD
Group: File tools
URL: http://www.kipple.pe.kr/win/unalz/
Source0: %{url}%{name}-%{version}.tgz
# We are using the internal zlib
Patch0: unalz-internal-zlib.patch
Patch1: unalz-optflags.patch
# Respect zlib get_crc_table() type
Patch2: unalz-0.65-zlib-get_crc_table-return-type-can-vary.patch
BuildRequires: zlib-devel
Source44: import.info

%description
Unalz is a utility to decompress .alz files. It supports bzip2/raw format 
transformation, splitting the compressed file into smaller chunks (alz, a00, 
a01, ...), extract password protected .alz files, and CRC checks.

%prep
%setup -q -n %{name}
%patch0 -p1 -b .zlib
%patch1 -p1 -b .optflags
%patch2 -p1 -b .get_crc_table

rm -fr zlib

# Fix permissions and encoding issues
for i in $(find . -type f); do
   chmod -x $i
   iconv -f UHC -t UTF8 $i -o $i.utf8
   sed 's|\r||' $i.utf8 > $i.eol
   touch -r $i $i.eol
   mv $i.eol $i
done

%build
export LDFLAGS="$RPM_OPT_FLAGS"
export CFLAGS="$RPM_OPT_FLAGS"
make %{?_smp_mflags} linux-utf8

%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
install -p %{name} $RPM_BUILD_ROOT%{_bindir}

%files
%doc readme.txt 
%{_bindir}/%{name}

%changelog
