# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with static

Name:           unhide
Version:        20220611
Release:        alt1_1
Summary:        Tool to find hidden processes and TCP/UDP ports from rootkits
Group:          Security/Networking
License:        GPLv3+
URL:            https://www.unhide-forensics.info/
Source0:        https://github.com/YJesus/Unhide/archive/v%{version}/Unhide-%{version}.tar.gz
%if %{with static}
BuildRequires:	glibc-devel-static
%endif
Source44: import.info

%description
Unhide is a forensic tool to find hidden processes and TCP/UDP ports by
rootkits / LKMs or by another hidden technique.

%prep
%setup -qn Unhide-%{version}

%build
gcc %{optflags} %{?with_static:--static}  -pthread unhide-linux*.c unhide-output.c -o unhide-linux
gcc %{optflags} %{?with_static:--static}  unhide_rb.c -o unhide_rb
gcc %{optflags} %{?with_static:--static}  unhide-tcp.c unhide-tcp-fast.c unhide-output.c  -o unhide-tcp

%install

# binaries
install -Dp -m0755 unhide-linux %{buildroot}%{_sbindir}/unhide-linux
install -Dp -m0755 unhide-tcp %{buildroot}%{_sbindir}/unhide-tcp
install -Dp -m0755 unhide_rb %{buildroot}%{_sbindir}/unhide_rb

# man pages
install -d %{buildroot}%{_mandir}/man8
install -d %{buildroot}%{_mandir}/es/man8
install -d %{buildroot}%{_mandir}/fr/man8

install -p -m0644 man/*.8 -t %{buildroot}%{_mandir}/man8/
install -p -m0644 man/es/*.8 -t %{buildroot}%{_mandir}/es/man8/
install -p -m0644 man/fr/*.8 -t %{buildroot}%{_mandir}/fr/man8/

# symlinks
ln -s unhide-linux %{buildroot}%{_sbindir}/unhide
ln -s unhide.8 %{buildroot}%{_mandir}/man8/unhide-linux.8
ln -s unhide.8 %{buildroot}%{_mandir}/es/man8/unhide-linux.8
ln -s unhide.8 %{buildroot}%{_mandir}/fr/man8/unhide-linux.8


%find_lang %{name} --with-man --all-name

%files -f %{name}.lang
%doc changelog LEEME.txt README.txt
%{_mandir}/man8/unhide*
%{_sbindir}/unhide*


%changelog
