# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-install python3(sqlite3) python3-module-setuptools
# END SourceDeps(oneline)
%filter_from_requires /^python....run_uh./d
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		unknown-horizons
Version:	2019.1
Release:	alt1_12
License:	GPLv2+ and CC-BY-SA 3.0 and OFL
Summary:	A popular economy and city building 2D RTS game
Url:		https://unknown-horizons.org
Group:		Games/Strategy
Source0:	https://github.com/unknown-horizons/unknown-horizons/archive/%{version}.tar.gz
Patch0:		unknown-horizons-2019.1-mga-gamespath.patch
# cherry picked from:
# https://github.com/unknown-horizons/unknown-horizons/commit/2fdb225f62f66bf474e19d9b1bcfbaf691672c43
Patch1:		unknown-horizons-2019.1-replace-deprecated-to-distro-package.patch
Patch2:		0001-fixs-for-Phyton-3.9-2955.patch
Patch3:		0001-CVE-2020-14343.patch
# Backported from upstream
Patch4:		0001-remove-dead-Python2-code-2963.patch
Patch5:		0001-SyntaxWarning-is-with-a-literal.-2924.patch
Patch6:		0001-Rename-instances-of-collections.Iterable-into-collec.patch
BuildArch:	noarch

BuildRequires:  desktop-file-utils
# Required, docbook-xsl-stylesheets : to build man page
BuildRequires:	docbook-style-xsl
BuildRequires:	libfife-devel >= 0.4.2
BuildRequires:	intltool
# Required, libxslt : to build man page
BuildRequires:	xsltproc
BuildRequires:	libxslt-devel
BuildRequires:	python3-devel
BuildRequires:	python3-module-distro
BuildRequires:	python3-module-distutils-extra
BuildRequires:	python3-module-Pillow

Requires:	python3-module-fife >= 0.4.2
Requires:	python3 python3-tools
Requires:	python3-module-future
Requires:	python3-module-yaml
Requires:	%{name}-data = %{version}
Source44: import.info

%description
Unknown Horizons is a 2D real-time strategy simulation with an emphasis
on economy and city building. Expand your small settlement to a strong
and wealthy colony, collect taxes and supply your inhabitants with
valuable goods. Increase your power with a well balanced economy and
with strategic trade and diplomacy.

%package data
Summary:	Game data for the %{name} game
Group:		Games/Strategy
BuildArch:	noarch
Requires:	%{name} = %{version}

%description data
This package contains data files for %{name} game.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1


%build
%python3_build build_i18n

# force generation of atlas.sql
/usr/bin/python3 horizons/engine/generate_atlases.py 2048

%install
%python3_install

# menu
desktop-file-install --dir %{buildroot}%{_datadir}/applications build/share/applications/unknown-horizons.desktop

%files
%doc doc/AUTHORS.md doc/CHANGELOG.md doc/LICENSE
%{python3_sitelibdir_noarch}/*.egg-info
%{python3_sitelibdir_noarch}/horizons/
%{_datadir}/applications/%{name}.desktop
%{_bindir}/%{name}
%{_datadir}/pixmaps/unknown-horizons.xpm
%{_mandir}/man6/%{name}.6*

%files data
%{_gamesdatadir}/%{name}/


%changelog
