Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
# END SourceDeps(oneline)
Name:           urlwatch
Version:        1.18
Release:        alt1_5
Summary:        A tool for monitoring webpages for updates

License:        BSD
URL:            http://thpinfo.com/2008/urlwatch/
Source0:        http://thpinfo.com/2008/%{name}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  python3-dev
BuildRequires:  python3-module-distribute
BuildRequires: python-tools-2to3 python-tools-i18n python-tools-idle python-tools-pynche python-tools-smtpd
Source44: import.info

%description
This script is intended to help you watch URLs and get notified (via
email or in your terminal) of any changes. The change notification
will include the URL that has changed and a unified diff of what has
changed.

The script supports the use of a filtering hook function to strip
trivially-varying elements of a webpage.

Basic features

* Simple configuration (text file, one URL per line)
* Easily hackable (clean Python implementation)
* Can run as a cronjob and mail changes to you
* Always outputs only plaintext - no HTML mails :)
* Supports removing noise (always-changing website parts)
* Example hooks to filter content in Python

%prep
%setup -q
2to3 -w urlwatch lib/urlwatch/*.py share/urlwatch/examples/hooks.py.example setup.py

%build
%{__python3} setup.py build

%install
%{__python3} setup.py install -O1 --skip-build --root=%{buildroot}
# Fix exec permission for rpmlint
chmod 0755 %{buildroot}%{python3_sitelibdir_noarch}/%{name}/*txt.py
chmod a+x %{buildroot}%{python3_sitelibdir_noarch}/%{name}/handler.py

%files
%doc ChangeLog COPYING
%{_mandir}/man*/*.*
%{_bindir}/%{name}
%{_datadir}/%{name}/examples/
%{python3_sitelibdir_noarch}/%{name}/
%{python3_sitelibdir_noarch}/%{name}*.egg-info

%changelog
