# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: boost-devel gcc-c++ libGLU-devel libogg-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _smp_ncpus_max 4

%define sname   ValyriaTear

Name:           valyriatear
Version:        1.1.0
Release:        alt1_5
Summary:        Valyria Tear is a free 2D J-RPG based on the Hero of Allacrost engine
Group:          Games/Adventure
License:        GPLv2+
URL:            https://valyriatear.blogspot.com
Source0:        https://github.com/ValyriaTear/ValyriaTear/releases/download/%{version}/%{sname}-src-with-deps-%{version}.tar.gz
Patch0:         0001-Fix-Version-tag-in-desktop-file.patch
Patch1:         valyriatear-missing-stdint.patch

BuildRequires:  boost-complete
BuildRequires:  cmake
BuildRequires:  gettext
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(glew)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(lua-5.1)
BuildRequires:  pkgconfig(openal)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_image)
BuildRequires:  pkgconfig(SDL2_ttf)
BuildRequires:  pkgconfig(vorbisfile)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(zlib)

Requires:       %{name}-data = %{version}-%{release}
Source44: import.info

%description
Valyria Tear is a free 2D J-RPG game based on the Hero of Allacrost engine.

You can play it very much like a typical console role-playing game.
You can explore maps and talk to non-playable characters (NPCs),
fight active-time battles against multiple enemies,
and manage your characters and equipment through a series of menus.

%package data
Group: Games/Adventure
Summary:        Data files for 2D J-RPG Valyria Tear
License:        GPLv2 and GPLv2+ and GPLv3 and CC-BY-SA and CC-BY and CC0 and OFL
BuildArch:      noarch

%description data
Data files for 2D J-RPG Valyria Tear.

%prep
%setup -q -n %{sname}
%patch0 -p1
%patch1 -p1


%build
%{mageia_cmake} \
  -DPKG_BINDIR=%{_gamesbindir} \
  -DPKG_DATADIR=%{_gamesdatadir}/%{name}
%mageia_cmake_build

%install
%mageia_cmake_install

install -D -p -m644 doc/%{name}.6 %{buildroot}%{_mandir}/man6/%{name}.6

# Not using %%files_lang so that the user has the in-game possibility to change the locale
%files
%doc AUTHORS MANUAL
%doc --no-dereference LICENSES.txt COPYING.*
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/locale/*/LC_MESSAGES/%{name}.mo
%{_gamesbindir}/%{name}
%{_iconsdir}/hicolor/48x48/apps/%{name}.png
%{_mandir}/man6/%{name}.6*

%files data
%{_gamesdatadir}/%{name}/


%changelog
