Group: Editors
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/ispell gcc-c++ libXmu-devel perl(DB_File.pm) perl(HTML/Toc.pm) perl(HTML/TocGenerator.pm) perl(IO/Pty.pm) perl(Net/Dict.pm) perl(Pod/Text.pm) xorg-proto-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		vile
Version:	9.8z
Release:	alt1_2
Summary:	VI Like Emacs
License:	GPLv2
URL:		https://invisible-island.net/vile/
Source0:	https://invisible-island.net/archives/vile/current/%{name}-%{version}.tgz
BuildRequires:	libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:	flex
BuildRequires:	gcc
BuildRequires:	desktop-file-utils
Requires:	%{name}-common = %{version}-%{release}
Source44: import.info

%package	common
Group: Editors
Summary:	The common files needed by any version of the vile editor

%package -n	xvile
Group: Editors
Summary:	VI Like Emacs
BuildRequires:	libXpm libXpm-devel
BuildRequires:	libXaw-devel
BuildRequires:	libXt-devel
BuildRequires:	rpm-build-perl
Requires:	fonts-bitmap-misc
Requires:	%{name}-common = %{version}-%{release}


%description	common
vile is a text editor which is extremely compatible with vi in terms of "finger
feel".  In addition, it has extended capabilities in many areas, notably
multi-file editing and viewing, syntax highlighting, and key rebinding.
vile-common provides the files needed for all versions of vile.

%description -n xvile
xvile is a text editor which is extremely compatible with vi in terms of "finger
feel".  In addition, it has extended capabilities in many areas, notably
multi-file editing and viewing, syntax highlighting, and key rebinding.

%description
vile is a text editor which is extremely compatible with vi in terms of "finger
feel".  In addition, it has extended capabilities in many areas, notably
multi-file editing and viewing, syntax highlighting, and key rebinding.

%prep

# loadable filters are mistreated by rpmbuild
#define debug_package #{nil}

%setup -q

%build
%configure --with-loadable-filters \
	   --disable-rpath-hack \
	   --disable-stripping

%make_build vile

DESKTOP_FLAGS=--vendor='' \
%configure --with-loadable-filters \
	   --disable-rpath-hack \
	   --disable-stripping \
	   --with-app-defaults=%{_x11appconfdir} \
	   --with-screen=Xaw \
	   --with-icon-theme \
	   --with-icondir=%{_datadir}/icons/ \
	   --with-pixmapdir=%{_datadir}/pixmaps/ \
	   --with-xpm

%make_build xvile
touch vile

%install
make install DESTDIR=%{buildroot} INSTALL='install -p' TARGET='xvile'
make install DESTDIR=%{buildroot} INSTALL='install -p' TARGET='vile'
make install-desktop DESKTOP_FLAGS=--vendor='' DESKTOP_DIR=%{buildroot}%{_datadir}/applications

rm -v -f %{buildroot}%{_datadir}/applications/lxvile.desktop
rm -v -f %{buildroot}%{_datadir}/applications/uxvile.desktop

pushd %{buildroot}%{_mandir}/man1 
ln -s xvile.1 uxvile.1
ln -s xvile.1 lxvile.1
popd

%files
%{_bindir}/vile
%{_bindir}/vile-pager
%{_bindir}/vile-libdir-path
%{_bindir}/vile-to-html
%{_mandir}/man1/vile*.1*

%files common
%doc AUTHORS COPYING CHANGES README doc/*doc
%{_datadir}/vile/
%{_libdir}/vile/

%files -n xvile
%{_bindir}/lxvile
%{_bindir}/lxvile-fonts
%{_bindir}/uxvile
%{_bindir}/xshell.sh
%{_bindir}/xvile
%{_bindir}/xvile-pager
%{_bindir}/xvile-libdir-path
%{_bindir}/xvile-to-html
%{_mandir}/man1/xvile*.1*
%{_mandir}/man1/lxvile.1*
%{_mandir}/man1/uxvile.1*
%{_datadir}/pixmaps/vile.xpm
%{_datadir}/icons/hicolor/*/apps/vile.*
%{_x11appconfdir}/XVile
%{_x11appconfdir}/UXVile
%{_datadir}/applications/xvile.desktop


%changelog
