Group: Editors
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache2/Const.pm) perl(Apache2/Log.pm) perl(Apache2/Request.pm) perl(Apache2/RequestIO.pm) perl(Apache2/RequestRec.pm) perl(Apache2/RequestUtil.pm) perl(Time/HiRes.pm) perl(XML/Writer.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define otl2html_version 1.40
%global upstream_name vimoutliner

Name:           vim-%{upstream_name}
Version:        0.4.0
Release:        alt1_11
Summary:        Script for building an outline editor on top of Vim
# LICENSE says v2, but the code all says v2+
License:        GPLv2+
URL:            https://github.com/vimoutliner/vimoutliner
Source0: https://github.com/vimoutliner/vimoutliner/archive/%{version}/%{upstream_name}-%{version}.tar.gz
# FIXME: www.vimoutliner.org doesn't exist anymore
# the following two tarballs are from http://www.vimoutliner.org as well, but
# they are in CMS without good URLs.
Source1:        otl2html-%{otl2html_version}.tgz
Source2:        otl_handler.tgz
# things which are in discussion about putting upstream
Source3:        vimoutliner-local.tar.bz2
Source4:        vimoutliner-README.Fedora
Source5:        vimoutliner-Makefile
Source6:        vim-vimoutliner.metainfo.xml
BuildArch:      noarch
BuildRequires:      rpm-build-perl
Requires:       vim-common vimtutor python
Requires(post): vim-common vimtutor
Requires(postun): vim-common vimtutor
Source44: import.info
#Requires:       libxml-writer-perl libpalm-perl

%description
Vimoutliner provides commands for building using the Vim text editor as an
outline editor. For more explanation on what outlines are and what they are
good for see the script's webpage at
https://github.com/vimoutliner/vimoutliner and the general discussion of outlines on
http://www.troubleshooters.com/tpromag/199911/199911.htm.

%prep
%setup -q -n %{upstream_name}-%{version} -a 1 -a 2 -a 3
cp -f -p  %{SOURCE4} README.Fedora
cp -f -p  %{SOURCE5} Makefile
# mv ../{CHANGELOG,INSTALL,README*,install.sh,LICENSE} .
find . -name .\*.swp -delete
mv otl2html-* doc/otl2html
mv otl_handler doc/otl_handler
mv doc/otl2html/README README.otl2html
mv doc/otl_handler/README README.otl_handler
find doc/ -type f -perm /111 -exec chmod -x '{}' \;
rm doc/otl2html/otl2html.py

%build
cp -r doc examples

%install
make DESTDIR=$RPM_BUILD_ROOT install
install -m a+rx,u+w -d $RPM_BUILD_ROOT%{_sysconfdir}
install -p -m a+r,u+w vimoutlinerrc \
   $RPM_BUILD_ROOT%{_sysconfdir}/vimoutlinerrc
install -m a+rx,u+w -d $RPM_BUILD_ROOT%{_datadir}/mime/packages
install -p -m a+r,u+w vimoutliner-mimefile.xml \
   $RPM_BUILD_ROOT%{_datadir}/mime/packages/vimoutliner.xml

# install app metadata
install -p -D %{SOURCE6} %{buildroot}%{_datadir}/appdata/%{name}.metainfo.xml

%post
cd %{_datadir}/vim/vimfiles/doc
vim -u NONE -esX -c "helptags ." -c quit
grep -q "filetype plugin on" /etc/vimrc \
    || echo -e "\nfiletype plugin on" >>/etc/vimrc

%postun
if [ $1 -eq 0 ]; then
   cd %{_datadir}/vim/vimfiles/doc
   vim -u NONE -esX -c "helptags ." -c quit
fi

%files
%doc README.otl2html README.otl_handler README.Fedora LICENSE TODO.otl
%doc examples CHANGELOG
%config(noreplace) %{_sysconfdir}/vimoutlinerrc
#%__bindir/otl2html
%{_bindir}/votl_maketags
%{_datadir}/vim/vimfiles/*/*
%{_datadir}/mime/packages/vimoutliner.xml
%{_mandir}/man1/*.1*
%{_datadir}/appdata/*.xml

%changelog
