Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: tex(dehypht.tex) texlive-dist
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           vinci
Version:        1.0.5
Release:        alt2_26
Summary:        Algorithms for volume computation

License:        GPL-1.0-or-later
URL:            https://www.multiprecision.org/vinci/
Source0:        https://www.multiprecision.org/downloads/%{name}-%{version}.tar.gz
# Man page written by Jerry James using text found in the sources.  Therefore,
# the man page has the same copyright and license as the sources.
Source1:        %{name}.1

# See https://fedoraproject.org/wiki/Changes/EncourageI686LeafRemoval
ExcludeArch:    %{ix86}

BuildRequires:  gcc
BuildRequires:  tex(latex)

Requires:       coreutils
Requires:       lrslib-utils
Source44: import.info

%description
The volume is one of the central properties of a convex body, and volume
computation is involved in many hard problems.  Applications range from
rather classical ones as in convex optimization to problems in remote
fields like algebraic geometry where the number of common roots of
polynomials can be related to a special polytope volume.

Part of the fascination of the subject stems from the discrepancy
between the intuitive notion of "volume" and the actual hardness of
computing it.  Despite this discouraging complexity - algorithms in
general need exponential time in the input dimension - steadily growing
computer power enables us to attack problems of practical interest.

Vinci is an easy to install C package that implements the state of the
art algorithms for volume computation.  It is the fruit of a research
project carried out at the IFOR (Institute for Operations Research) at
ETH ZA.rich, in collaboration with Benno BA.eler and Komei Fukuda.

%prep
%setup -q


%build
# Link with the right flags
sed -i 's|-o vinci|& %{build_ldflags}|' makefile

%make_build OPT='%{optflags}'
pdflatex manual.tex
pdflatex manual.tex

%install
mkdir -p %{buildroot}%{_bindir}
install -m 755 %{name} %{buildroot}%{_bindir}

mkdir -p %{buildroot}%{_mandir}/man1
sed -e "s/@VERSION@/%{version}/" %{SOURCE1} > \
  %{buildroot}%{_mandir}/man1/%{name}.1
touch -r %{SOURCE1} %{buildroot}%{_mandir}/man1/%{name}.1

%files
%doc ChangeLog manual.pdf
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
