Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global revision 164

Name: virtualplanet
Version: 2.5
Release: alt3_11.%{revision}svn
Summary: An atlas for planets surface formations
# Some component of glscene used by virtualplanet are licensed MPLv1.1 only
License: GPLv3+ and MPLv1.1
URL: http://www.ap-i.net/avp/
# Virtual Planetary Atlas source contains Mac and Windows stuff
# so we use a script to remove that before importing in Fedora.
# Use this script to download svn version and clean it up:
# ./generate-tarball.sh 2.0 164
Source0: %{name}-%{version}-src-%{revision}-nopatents.tar.xz
Source1: generate-tarball.sh
# Base data
Source2: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_JPLeph.tgz
Source3: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Overlay.tgz
# Base textures
Source4: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Callisto.tgz
Source5: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Europa.tgz
Source6: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Ganymede.tgz
Source7: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Io.tgz
Source8: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Jupiter.tgz
Source9: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Mars.tgz
Source10: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Mercury.tgz
Source11: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Venus.tgz
# Historical textures
Source12: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Callisto_Historical.tgz
Source13: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Europa_Historical.tgz
Source14: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Ganymede_Historical.tgz
Source15: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Io_Historical.tgz
Source16: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Jupiter_Historical.tgz
Source17: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Mars_Historical.tgz
Source18: http://sourceforge.net/projects/%{name}/files/9-Source_Data/VPA_Base_Texture_Mercury_Historical.tgz


# Virtualplanet doesn't support set FPC options from command line
# This patch changes options in Makefiles to avoid stripping
# executables and to enable debug info
# Fedora specific, not reported upstream
Patch1:         vpa-2.5-fix_debuginfo.patch

# Virtualplanet use wget to download source data
# We disable that and use source files
# Fedora specific, not reported upstream
Patch2:         virtualplanet-wgetdata.patch

# Appdata files are present in sources but not installed
Patch99:        vpa-2.5-appdata.patch


# virtualplanet cannot be built on these arches due to incompatibile GLScene component
ExcludeArch:    ppc64le %{arm} aarch64


BuildRequires:  desktop-file-utils
BuildRequires:  dos2unix
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  fpc-compiler fpc-ide fpc-units-gfx fpc-units-misc fpc-utils
BuildRequires:  lazarus >= 1.6.4
BuildRequires:  libappstream-glib

BuildRequires:  pkgconfig(glu)
BuildRequires:  pkgconfig(xxf86vm)

Requires:       %{name}-data-base = %{version}-%{release}
# Virtualplanet requires libpasastro to function properly
# but rpm doesn't find this autorequire
Requires:       libpasastro
Source44: import.info


%description
Virtual Planets Atlas displays surface information for planets
Jupiter, Mars, Venus and Mercury and for the major moons
of Jupiter.

It is based on the interface of well known Virtual Moon Atlas

%package doc
Group: Other
Summary:        Documentation files for Virtual Planets Atlas
License:        GFDL
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description doc
Documentation files for Virtual Planets Atlas

%package data-base
Group: Other
Summary:        Base data for Virtual Planets Atlas
License:        Public Domain
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description data-base
Base data for Virtual Planets Atlas. It includes base textures, 
database and overlays

%package data-historical
Group: Other
Summary:        Historical textures for Virtual Planets Atlas
License:        Public Domain
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description data-historical
Historical addon textures for Virtual Planets Atlas

%prep
%setup -q -n %{name}-%{version}-src
%patch1 -p1
%patch2 -p1
%patch99 -p1



%build
./configure lazarus=%{_libdir}/lazarus prefix=%{_prefix}

# Virtualplanet doesn't like parallel building so we don't use macro.
# Some components support passing options to fpc compiler 
# to generate debug info.
make fpcopts="-O1 -gw3 -fPIC"

# Put additional catalogs files where required for installation
cp -p %SOURCE2 ./BaseData
cp -p %SOURCE3 ./BaseData
cp -p %SOURCE4 ./BaseData
cp -p %SOURCE5 ./BaseData
cp -p %SOURCE6 ./BaseData
cp -p %SOURCE7 ./BaseData
cp -p %SOURCE8 ./BaseData
cp -p %SOURCE9 ./BaseData
cp -p %SOURCE10 ./BaseData
cp -p %SOURCE11 ./BaseData
cp -p %SOURCE12 ./BaseData
cp -p %SOURCE13 ./BaseData
cp -p %SOURCE14 ./BaseData
cp -p %SOURCE15 ./BaseData
cp -p %SOURCE16 ./BaseData
cp -p %SOURCE17 ./BaseData
cp -p %SOURCE18 ./BaseData


%install
# Install main program
make install PREFIX=%{buildroot}%{_prefix}

# Install data files
make install install_data PREFIX=%{buildroot}%{_prefix}
make install install_data2 PREFIX=%{buildroot}%{_prefix}

# For now we don't provide extra textures
# because they're over 1GB of data
#make install install_data3 PREFIX=%%{buildroot}%%{_prefix}


%check
# Menu entry
desktop-file-validate %{buildroot}%{_datadir}/applications/virtualplanet.desktop

# Appdata file check
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/*.appdata.xml

%files
%doc --no-dereference gpl-3.0.txt LICENSE
%doc %{_datadir}/doc/%{name}
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/metainfo/%{name}.appdata.xml
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/icons/*/*/*/%{name}.png
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/language/

%files doc
%doc --no-dereference doc/fdl-1.3.txt doc/LICENSE
%doc %{_datadir}/%{name}/doc/

%files data-base
%{_datadir}/%{name}/data/
%{_datadir}/%{name}/Database/
%{_datadir}/%{name}/Overlay/
%{_datadir}/%{name}/Textures/
%exclude %{_datadir}/%{name}/Textures/*/Historical/

%files data-historical
%{_datadir}/%{name}/Textures/*/Historical/
%{_datadir}/metainfo/%{name}-data-historical.metainfo.xml


%changelog
