Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-alternatives
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _hardened_build 1

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:		voms
Version:	2.1.0
Release:	alt2_0.32.rc3
Summary:	Virtual Organization Membership Service

License:	Apache-2.0
URL:		https://italiangrid.github.io/voms/
Source0:	https://github.com/italiangrid/%{name}/archive/v%{version}-rc3/%{name}-%{version}-rc3.tar.gz
#		Post-install setup instructions:
Source1:	%{name}.INSTALL
#		https://github.com/italiangrid/voms/pull/105
Patch0:		0001-Catch-exception-by-reference.patch
#		https://github.com/italiangrid/voms/pull/106
Patch1:		0002-Fix-warning-about-possible-use-after-free.patch
#		https://github.com/italiangrid/voms/pull/107
Patch2:		0003-Fix-doxygen-warning.patch
#		https://github.com/italiangrid/voms/pull/108
Patch3:		0004-Fix-warning-about-possible-string-truncation.patch
#		https://github.com/italiangrid/voms/pull/104
Patch4:		0005-config.h-must-not-be-included-in-public-header-file.patch
Patch5:		0006-Include-config.h-before-other-header-files.patch
#		https://github.com/italiangrid/voms/pull/109
Patch6:		0007-Compile-and-link-libvomsapi-with-proper-thread-flags.patch
#		Backport from upstream
Patch7:		0008-Fix-memory-leaks-and-double-deletes.patch
#		https://github.com/italiangrid/voms/pull/116
Patch8:		0009-If-a-detailed-error-message-is-available-do-not-over.patch
#		https://github.com/italiangrid/voms/pull/112
Patch9:		0010-Add-lexparse.h-headers-for-lexer-parser-integration-.patch
#		https://github.com/italiangrid/voms/pull/121
Patch10:	0011-Only-process-authority-and-subject-key-identifiers-i.patch
#		https://github.com/italiangrid/voms/pull/113
Patch11:	0012-Consider-the-Authority-Key-Id-extension-only-if-it-s.patch

BuildRequires:	gcc-c++
BuildRequires:	libssl-devel
BuildRequires:	libexpat-devel
BuildRequires:	libgsoap-devel
BuildRequires:	libtool
BuildRequires:	libxslt xsltproc
BuildRequires:	docbook-style-xsl
BuildRequires:	doxygen
%if %{use_systemd}
BuildRequires:	rpm-macros-systemd
%endif
Source44: import.info

%description
The Virtual Organization Membership Service (VOMS) is an attribute authority
which serves as central repository for VO user authorization information,
providing support for sorting users into group hierarchies, keeping track of
their roles and other attributes in order to issue trusted attribute
certificates and SAML assertions used in the Grid environment for
authorization purposes.

This package provides libraries that applications using the VOMS functionality
will bind to.

%package devel
Group: Development/C
Summary:	Virtual Organization Membership Service Development Files
Requires:	%{name} = %{version}-%{release}

%description devel
The Virtual Organization Membership Service (VOMS) is an attribute authority
which serves as central repository for VO user authorization information,
providing support for sorting users into group hierarchies, keeping track of
their roles and other attributes in order to issue trusted attribute
certificates and SAML assertions used in the Grid environment for
authorization purposes.

This package provides header files for programming with the VOMS libraries.

%package doc
Group: Documentation
Summary:	Virtual Organization Membership Service Documentation
BuildArch:	noarch

%description doc
Documentation for the Virtual Organization Membership Service.

%package clients-cpp
Group: Networking/WWW
Summary:	Virtual Organization Membership Service Clients
Requires:	%{name} = %{version}-%{release}
Provides:	voms-clients = %{version}-%{release}
Obsoletes:	voms-clients < 2.0.12-3


%description clients-cpp
The Virtual Organization Membership Service (VOMS) is an attribute authority
which serves as central repository for VO user authorization information,
providing support for sorting users into group hierarchies, keeping track of
their roles and other attributes in order to issue trusted attribute
certificates and SAML assertions used in the Grid environment for
authorization purposes.

This package provides command line applications to access the VOMS
services.

%package server
Group: Networking/WWW
Summary:	Virtual Organization Membership Service Server
Requires:	%{name} = %{version}-%{release}

Requires(pre):		shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-submap shadow-utils
%if %{use_systemd}
%{?systemd_requires}
%else
%endif

%description server
The Virtual Organization Membership Service (VOMS) is an attribute authority
which serves as central repository for VO user authorization information,
providing support for sorting users into group hierarchies, keeping track of
their roles and other attributes in order to issue trusted attribute
certificates and SAML assertions used in the Grid environment for
authorization purposes.

This package provides the VOMS service.

%prep
%setup -q -n %{name}-%{version}-rc3
%patch0  -p1
%patch1  -p1
%patch2  -p1
%patch3  -p1
%patch4  -p1
%patch5  -p1
%patch6  -p1
%patch7  -p1
%patch8  -p1
%patch9  -p1
%patch10  -p1
%patch11  -p1

./autogen.sh

install -m 644 -p %{SOURCE1} README.Fedora

%build
%configure --disable-static --enable-docs --disable-parser-gen

%make_build

%install
%makeinstall_std

rm %{buildroot}%{_libdir}/*.la

%if %{use_systemd}
mkdir -p %{buildroot}%{_unitdir}
install -m 644 -p systemd/%{name}@.service %{buildroot}%{_unitdir}
rm %{buildroot}%{_initrddir}/%{name}
rm %{buildroot}%{_sysconfdir}/sysconfig/%{name}
%else
# Turn off default enabling of the service
sed -e 's/\(chkconfig: \)\w*/\1-/' \
    -e '/Default-Start/d' \
    -e 's/\(Default-Stop:\s*\).*/\10 1 2 3 4 5 6/' \
    -i %{buildroot}%{_initrddir}/%{name}
%endif

mkdir -p %{buildroot}%{_docdir}/%{name}
install -m 644 -p AUTHORS README.md %{buildroot}%{_docdir}/%{name}

mkdir -p %{buildroot}%{_docdir}/%{name}/VOMS_C_API
cp -pr doc/apidoc/api/VOMS_C_API/html %{buildroot}%{_docdir}/%{name}/VOMS_C_API
rm -f %{buildroot}%{_docdir}/%{name}/VOMS_C_API/html/installdox

mkdir -p %{buildroot}%{_docdir}/%{name}/VOMS_CC_API
cp -pr doc/apidoc/api/VOMS_CC_API/html %{buildroot}%{_docdir}/%{name}/VOMS_CC_API
rm -f %{buildroot}%{_docdir}/%{name}/VOMS_CC_API/html/installdox

for b in voms-proxy-init voms-proxy-info voms-proxy-destroy; do
  ## Rename client binaries
  mv %{buildroot}%{_bindir}/${b} %{buildroot}%{_bindir}/${b}2
  touch %{buildroot}/%{_bindir}/${b}
  chmod 755 %{buildroot}/%{_bindir}/${b}
  ## and man pages
  mv %{buildroot}%{_mandir}/man1/${b}.1 %{buildroot}%{_mandir}/man1/${b}2.1
  touch %{buildroot}%{_mandir}/man1/${b}.1
done


for rpm404_ghost in %{_bindir}/voms-proxy-destroy %{_bindir}/voms-proxy-info %{_bindir}/voms-proxy-init %{_mandir}/man1/voms-proxy-destroy.1* %{_mandir}/man1/voms-proxy-info.1* %{_mandir}/man1/voms-proxy-init.1*
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/voms-proxy-init_voms-clients-cpp<<EOF
%{_bindir}/voms-proxy-init	%{_bindir}/voms-proxy-init2	50
%{_mandir}/man1/voms-proxy-init.1.gz	%{_mandir}/man1/voms-proxy-init2.1.gz	%{_bindir}/voms-proxy-init2
EOF
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/voms-proxy-info_voms-clients-cpp<<EOF
%{_bindir}/voms-proxy-info	%{_bindir}/voms-proxy-info2	50
%{_mandir}/man1/voms-proxy-info.1.gz	%{_mandir}/man1/voms-proxy-info2.1.gz	%{_bindir}/voms-proxy-info2
EOF
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/voms-proxy-destroy_voms-clients-cpp<<EOF
%{_bindir}/voms-proxy-destroy	%{_bindir}/voms-proxy-destroy2	50
%{_mandir}/man1/voms-proxy-destroy.1.gz	%{_mandir}/man1/voms-proxy-destroy2.1.gz	%{_bindir}/voms-proxy-destroy2
EOF


%pre server
getent group %{name} >/dev/null || groupadd -r %{name}
getent passwd %{name} >/dev/null || useradd -r -g %{name} \
    -d %{_sysconfdir}/%{name} -s /sbin/nologin -c "VOMS Server Account" %{name}

%if %{use_systemd}
# Remove old init config when systemd is used
/sbin/service voms stop >/dev/null 2>&1 || :
/sbin/chkconfig --del voms >/dev/null 2>&1 || :
%endif

%if %{use_systemd}

%post server
if [ $1 -eq 1 ] ; then
    systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun server
if [ $1 -eq 0 ] ; then
    for INSTANCE in `systemctl | grep %{name}@ | awk '{print $1;}'`; do
	systemctl --no-reload disable $INSTANCE > /dev/null 2>&1 || :
	systemctl stop $INSTANCE > /dev/null 2>&1 || :
    done
fi

%postun server
if [ $1 -ge 1 ] ; then
    systemctl daemon-reload >/dev/null 2>&1 || :
    for INSTANCE in `systemctl | grep %{name}@ | awk '{print $1;}'`; do
	systemctl try-restart $INSTANCE >/dev/null 2>&1 || :
    done
fi

%else

%post server
if [ $1 = 1 ]; then
    /sbin/chkconfig --add %{name}
fi

%preun server
if [ $1 = 0 ]; then
    /sbin/service %{name} stop >/dev/null 2>&1 || :
    /sbin/chkconfig --del %{name}
fi

%postun server
if [ $1 -ge 1 ]; then
    /sbin/service %{name} condrestart >/dev/null 2>&1 || :
fi

%endif

%pre clients-cpp
if [ $1 -gt 1 ]; then
  for c in voms-proxy-init voms-proxy-info voms-proxy-destroy; do
    if [ -r %{_bindir}/$c -a ! -h %{_bindir}/$c ]; then
      rm -f %{_bindir}/$c
    fi
    if [ -r %{_mandir}/man1/$c.1.gz -a ! -h %{_mandir}/man1/$c.1.gz ]; then
      rm -f %{_mandir}/man1/$c.1.gz
    fi
  done
fi

%triggerpostun clients-cpp -- voms-clients
# Uninstalling the old voms-clients package will remove the alternatives
# for voms-clients-cpp - put them back in this triggerpostun script
%{_sbindir}/update-alternatives --install %{_bindir}/voms-proxy-init \
    voms-proxy-init %{_bindir}/voms-proxy-init2 50 \
    --slave %{_mandir}/man1/voms-proxy-init.1.gz voms-proxy-init-man \
    %{_mandir}/man1/voms-proxy-init2.1.gz
%{_sbindir}/update-alternatives --install %{_bindir}/voms-proxy-info \
    voms-proxy-info %{_bindir}/voms-proxy-info2 50 \
    --slave %{_mandir}/man1/voms-proxy-info.1.gz voms-proxy-info-man \
    %{_mandir}/man1/voms-proxy-info2.1.gz
%{_sbindir}/update-alternatives --install %{_bindir}/voms-proxy-destroy \
    voms-proxy-destroy %{_bindir}/voms-proxy-destroy2 50 \
    --slave %{_mandir}/man1/voms-proxy-destroy.1.gz voms-proxy-destroy-man \
    %{_mandir}/man1/voms-proxy-destroy2.1.gz

%files
%{_libdir}/libvomsapi.so.1*
%dir %{_sysconfdir}/grid-security
%dir %{_sysconfdir}/grid-security/vomsdir
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/vomses.template
%doc %dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/AUTHORS
%doc %{_docdir}/%{name}/README.md
%doc --no-dereference LICENSE

%files devel
%{_libdir}/libvomsapi.so
%{_includedir}/%{name}
%{_libdir}/pkgconfig/%{name}-2.0.pc
%{_datadir}/aclocal/%{name}.m4
%{_mandir}/man3/*

%files doc
%doc %dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/AUTHORS
%doc %{_docdir}/%{name}/VOMS_C_API
%doc %{_docdir}/%{name}/VOMS_CC_API
%doc --no-dereference LICENSE

%files clients-cpp
%_altdir/voms-proxy-destroy_voms-clients-cpp
%_altdir/voms-proxy-info_voms-clients-cpp
%_altdir/voms-proxy-init_voms-clients-cpp
%{_bindir}/voms-proxy-destroy2
%{_bindir}/voms-proxy-info2
%{_bindir}/voms-proxy-init2
%{_bindir}/voms-proxy-fake
%{_bindir}/voms-proxy-list
%{_bindir}/voms-verify
%{_mandir}/man1/voms-proxy-destroy2.1*
%{_mandir}/man1/voms-proxy-info2.1*
%{_mandir}/man1/voms-proxy-init2.1*
%{_mandir}/man1/voms-proxy-fake.1*
%{_mandir}/man1/voms-proxy-list.1*

%files server
%{_sbindir}/%{name}
%if %{use_systemd}
%{_unitdir}/%{name}@.service
%else
%{_initrddir}/%{name}
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%endif
%attr(-,voms,voms) %dir %{_sysconfdir}/%{name}
%dir %{_sysconfdir}/grid-security/%{name}
%attr(-,voms,voms) %dir %{_localstatedir}/log/%{name}
%{_datadir}/%{name}/mysql2oracle
%{_datadir}/%{name}/upgrade1to2
%{_datadir}/%{name}/voms.data
%{_datadir}/%{name}/voms_install_db
%{_datadir}/%{name}/voms-ping
%{_datadir}/%{name}/voms_replica_master_setup.sh
%{_datadir}/%{name}/voms_replica_slave_setup.sh
%{_mandir}/man8/voms.8*
%doc README.Fedora

%changelog
