# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/epstopdf /usr/bin/man2html
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           vrq
Version:        1.0.130
Release:        alt1_4
Summary:        Verilog tool framework with plugins for manipulating source code

Group:          Engineering
License:        GPLv2+
URL:            http://vrq.sourceforge.net/
Source0:        http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz

# ---- Exclusive Arch: ----
# plugin/sim uses x86 inline assembly

ExclusiveArch:  %{ix86} x86_64

BuildRequires:  gcc-c++
BuildRequires:  gcc
BuildRequires:  bison flex help2man doxygen iverilog readline-devel
BuildRequires:  zlib-devel bzlib-devel perl-base libltdl7-devel
Source44: import.info

%description
VRQ is modular verilog parser that supports plugin tools to process verilog. 
Multiple tools may be invoked in a pipeline fashion within a single execution 
of vrq. It is a generic front-end parser with support for plugin backend 
customizable tools.

%package devel
Summary:        Header files and libraries for Vrq development
Group:          Development/Other
Requires:       %{name} = %{version}-%{release}

%description devel
The vrq-devel package contains the header files and libraries needed
to develop backend plugin customization tools for the vrq tool framework.

%prep
%setup -q

rm -rf `find . -name CVS`
rm -f `find . -name *.o`
rm -f `find . -name *.so`
sed -i "s|^MYDOCDIR = |MYDOCDIR = \$(DESTDIR)|" doc/Makefile*

%build
%configure
%make_build

%install
%makeinstall_std
rm -f `find %{buildroot} -name *.la`
rm -rf `find %{buildroot} -name latex`

# add some doc files into the buildroot manually (#992864)
for f in AUTHORS ChangeLog COPYING README doc/faq.html ; do
    install -p -m0644 -D $f %{buildroot}%{_docdir}/%{name}/${f}
done

install -d -m0755 %{buildroot}%{_docdir}/%{name}/doc
cp -pr doc/html %{buildroot}%{_docdir}/%{name}/doc

install -d -m0755 %{buildroot}%{_docdir}/%{name}/plugin
cp -pr plugin/examples %{buildroot}%{_docdir}/%{name}/plugin

rm -rf %{buildroot}%{_docdir}/%{name}-%{version}


%files
%dir %{_docdir}/%{name}
%{_docdir}/%{name}/AUTHORS
%{_docdir}/%{name}/ChangeLog
%{_docdir}/%{name}/COPYING
%{_docdir}/%{name}/README
%{_docdir}/%{name}/doc/faq.html
%{_bindir}/%{name}
%{_libdir}/%{name}-%{version}
%{_mandir}/man1/vrq.1*
%dir /usr/share/doc/vrq/doc

%files devel
%{_docdir}/%{name}/doc/html
%{_docdir}/%{name}/plugin/examples
%{_includedir}/%{name}-%{version}

%changelog
