Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: libcap-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%undefine _hardened_build

Name:           wavemon
Version:        0.9.5
Release:        alt1_2
Summary:        Ncurses-based monitoring application for wireless network devices

License:        GPLv2+
URL:            https://github.com/uoaerg/wavemon
Source0:        https://github.com/uoaerg/wavemon/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:  libpcap-devel
BuildRequires:  libnl-devel
BuildRequires:  autoconf
BuildRequires:  automake
Source44: import.info

%description
wavemon is a wireless device monitoring application that allows you to
watch all important information like device configuration, encryption,
and power management parameters and network information at once.
Adaptive level bargraphs for link quality, signal/noise strength and
signal-to-noise ratio.  The customizeable "level alarm" feature that 
notices the user of changes in signal level strength audibly and/or
visually. wavemon is able to list of access points in range and shows
full-screen level histogram displaying signal/noise levels and SNR.

%prep
%setup -q

sed -e '/^CFLAGS=/d' -i configure.ac
sed -r 's|\?=|=|g' -i Makefile.in
autoreconf -fiv

%build
CFLAGS="$RPM_OPT_FLAGS -fPIC -pie -Wl,-z,relro -Wl,-z,now"
CXXFLAGS="$RPM_OPT_FLAGS -fPIC -pie -Wl,-z,relro -Wl,-z,now"

export CFLAGS
export CXXFLAGS

%configure
%make_build

%install
%makeinstall_std
# Delete wrong placed doc files
rm -rf %{buildroot}%{_datadir}/%{name}/*

%files
%doc README.md
%doc --no-dereference LICENSE
%{_mandir}/man*/%{name}*.*
%{_bindir}/%{name}

%changelog
