# BEGIN SourceDeps(oneline):
BuildRequires: perl(Time/Local.pm) perl(Tk.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           wb_builder
Version:        1.0.3
Release:        alt1_16
Summary:        Wishbone Bus Builder

Group:          Engineering
License:        GPLv2
URL:            http://sourceforge.net/projects/fpgalibre/
Source0:        http://download.sourceforge.net/sourceforge/fpgalibre/%{name}-%{version}.tar.gz

# fixes some Perl strict warnings and errors
Patch0:         wb_builder-strict-warnings.patch
Patch1:         wb_builder-args.patch

BuildArch:      noarch
BuildRequires:  rpm-build-perl
Source44: import.info

%description
This package includes a HDL generator from a text description or via
GUI input for the Wishbone Bus.

The Wishbone Bus is an open source hardware computer bus intended
to let the parts of an integrated circuit communicate with each other.
The aim is to allow the connection of differing cores to each other
inside of a chip. The Wishbone Bus is used by many designs in the
OpenCores project.

%prep
%setup -q
%patch0
%patch1

# ---- Filtering Requires: ----
# In the perl script, "use IEEE.std_logic_1164.all" is meant
# to generate VHDL code and not for Perl

cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(IEEE.std_logic_1164.all)/d'
EOF

%global __perl_requires %{_builddir}/%{name}-%{version}/%{name}-req
chmod +x %{__perl_requires}
# ------------------------------------------


#fixing rpmlint warnings: file-not-utf8
for f in LEEME.txt README.txt ;
do
    iconv -f iso8859-1 -t utf-8 $f > $f.conv 
    mv -f $f.conv $f
done


%build


%install
install -d %{buildroot}%{_bindir}
install -pm 0755 wishbone.pl %{buildroot}%{_bindir}/wishbonebuilder


%files
%doc LEEME.txt LICENSE README.txt users_manual.pdf
%doc --no-dereference LICENSE
%{_bindir}/wishbonebuilder


%changelog
