Group: Other
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 4

Summary:        Wherever Change Directory: chdir for DOS and Unix
Name:           wcd
Version:        6.0.5
Release:        alt1_%autorelease

License:        GPL-2.0-or-later
URL:            https://waterlan.home.xs4all.nl/wcd.html
Source:         https://waterlan.home.xs4all.nl/wcd/wcd-%{version}.tar.gz

BuildRequires:  gcc

# For NLS (translations) in the program
BuildRequires:  gettext-tools
# For rebuilding and translating documentation
BuildRequires:  po4a
BuildRequires:  /usr/bin/pod2html
BuildRequires:  /usr/bin/pod2man
BuildRequires:  /usr/bin/podchecker

BuildRequires:  libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires:  libunistring-devel

%global wcd_d1 prefix='%{_prefix}' bindir='%{_bindir}' datadir='%{_datadir}'
%global wcd_d2 docdir='%{_docdir}/%{name}' sysconfdir='%{_sysconfdir}'
%global wcd_d3 mandir='%{_mandir}'
%global wcd_dirs %{wcd_d1} %{wcd_d2} %{wcd_d3}
# Paraphrased from doc/UNIX.txt:
#   UCS= Enable Unicode (UTF8) support.
#   UNINORM= Enable Unicode normalization. Requires libunistring. This takes at
#            least partial effect by being defined *to any value*, so do not
#            define it unless we want to enable it (we do).
#   ENABLE_NLS= Enable native language support. That is, use locale files. This
#               option takes effect by being defined *to any value*, so do not
#               define it unless we want to enable it (we do).
#   STATIC= Enable static linking. Make a standalone wcd binary. This option
#           takes effect by being defined *to any value*, so do not define it
#           unless we want to enable it.
#   DEBUG= Add -g to CFLAGS; the distro flags handle this.
#   DEBUGMSG= Makes wcd print verbose messages about accessing the file system.
#   LFS= Large File Support (LFS). This option cannot be effectively disabled
#        due to questionable logic in the Makefile, but that is fine because we
#        certainly want it to be enabled.
#   CURSES= Select curses library. Default is ncurses. There is some magic
#           behind the scenes, so we leave this alone.
#   NCURSES_DEBUG= Link with ncurses debug enabled library.
#   ASCII_TREE= Draw graphical tree with ASCII characters (instead of
#               line-drawing characters). This option takes effect by being
#               defined *to any value*, so do not define it unless we want to
#               enable it.
#   EXT= Set executable extension.
#   HMTLEXT= Set HTML manual file extension.
%global wcd_f1 UCS=1 UNINORM=1 ENABLE_NLS=1
%global wcd_f2 DEBUG=0 DEBUGMSG=0 LFS=1 NCURSES_DEBUG=0
%global wcd_f3 EXT= HTMLEXT=html
%global wcd_flags %{wcd_f1} %{wcd_f2} %{wcd_f3}
%global wcd_opts %{wcd_dirs} %{wcd_flags}
Source44: import.info

%description
Wcd is a command-line program to change directory fast. It saves time typing at
the keyboard. One needs to type only a part of a directory name and wcd will
jump to it. Wcd has a fast selection method in case of multiple matches and
allows aliasing and banning of directories. Wcd also includes a full screen
interactive directory tree browser with speed search.

Wcd was modeled after Norton Change Directory (NCD). NCD appeared first in The
Norton Utilities, Release 4, for DOS in 1987, published by Peter Norton. NCD
was written by Brad Kingsbury.


%package doc
Group: Other
Summary:        Documentation for wcs

BuildArch:      noarch

%description doc
%{summary}.

Man pages are included with the base package. This package provides the same
documentation in other forms, like plain text and HTML, as well as ancillary
plain-text documentation files, changelogs, and so on.


%prep
%setup -q



%build
%make_build -C src %{wcd_opts}


%install
%makeinstall_std install-profile -C src %{wcd_opts}
%find_lang wcd --with-man

%if 0%{?fedora} && 0%{?fedora} < 39
# Historically, this package accepted the upstream default of building the
# binary as wcd.exe, and the spec file contained claims that the name of the
# binary might change periodically and that this was not important.
#
# We feel that this was misguided: the name of the command that users type is
# *very* important, and it should match system conventions. We maintain the old
# name as a symbolic link for compatibility.
ln -s wcd '%{buildroot}%{_bindir}/wcd.exe'
%endif


%files -f wcd.lang
%{_docdir}/%{name}/copying.txt

%{_bindir}/wcd
%if 0%{?fedora} && 0%{?fedora} < 39
# See the comment in %%install.
%{_bindir}/wcd.exe
%endif
%{_mandir}/man1/wcd.1*

%config(noreplace) %{_sysconfdir}/profile.d/wcd.sh
%config(noreplace) %{_sysconfdir}/profile.d/wcd.csh


%files doc
%{_docdir}/%{name}/copying.txt
%doc %{_docdir}/%{name}/INSTALL.txt
%doc %{_docdir}/%{name}/README.txt
%doc %{_docdir}/%{name}/UNIX.txt
%doc %{_docdir}/%{name}/faq.txt
%doc %{_docdir}/%{name}/problems.txt
%doc %{_docdir}/%{name}/todo.txt
%doc %{_docdir}/%{name}/wcd.html
%doc %{_docdir}/%{name}/wcd.txt
%doc %{_docdir}/%{name}/whatsnew.txt
# Localized HTML and plain-text documentation
%doc %dir %{_docdir}/%{name}/*/
%doc %{_docdir}/%{name}/*/wcd.html
%doc %{_docdir}/%{name}/*/wcd.txt


%changelog
