Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: waf
# END SourceDeps(oneline)
Name:             weighttp
Summary:          Small tool to benchmark webservers
License:          MIT
URL:              http://redmine.lighttpd.net/projects/weighttp/

Version:          0.3
Release:          alt1_8

# Upstream doesn't release tarballs, so I created this one:
#     $ git clone git://git.lighttpd.net/weighttp && cd weighttp
#     $ git archive --format=tar --prefix=weighttp-0.3/ 1bdbe40 | xz -z > weighttp-0.3.tar.xz
#
# I use this specific git commit because it is the one for the 0.3 version.
# Unfortunately, upstream didn't tag it, even though they tagged v0.1 and v0.2
Source0:          %{name}-%{version}.tar.xz

BuildRequires:    libev-devel
Source44: import.info

# The build uses a bundled copy of waf, which requires python. If we ever
# start using the Fedora waf package instead, this will come in implictly.

%description
weighttp (pronounced weighty) is a lightweight and small benchmarking tool for
webservers.

It was designed to be very fast and easy to use and only supports a tiny
fraction of the HTTP protocol in order to be lean and simple.

weighttp supports multithreading to make good use of modern CPUs with multiple
cores as well as asynchronous i/o for concurrent requests within a single
thread.

For event handling, weighty relies on libev which fits the design perfectly,
being lightweight and fast itself. Thanks to that, weighty supports all modern
high-performance event interfaces like epoll or kqueue, that the major OSs
provide.


%prep
%setup -q


%build
export CFLAGS="%{optflags}"

# The bundled waf script seems to be 1.5.9, and the wscript was written for
# this version. It doesn't work any more with the waf version packaged in
# Fedora, as it is much more recent and the waf API changed since then.
# Using the Fedora waf package would require significant changes to the
# upstream wscript, so we use the bundled one for now.
./waf configure --prefix=%{_prefix}
./waf build %{?_smp_mflags}


%install
./waf install --destdir=%{buildroot}


%files
%doc COPYING
%{_bindir}/%{name}


%changelog
