Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           wiki2beamer
Version:        0.10.0
Release:        alt2_9
Summary:        Converts a simple wiki-like syntax to complex LaTeX beamer code
# Code is GPLv2+, documentation is GFDL
License:        GPLv2+ and GFDL
BuildArch:      noarch
BuildRequires:  python3-devel
# For generating man page
BuildRequires:  asciidoctor
URL:            https://github.com/wiki2beamer/wiki2beamer
Source0:        https://github.com/wiki2beamer/wiki2beamer/archive/%{name}-v%{version}/%{name}-%{version}.tar.gz
Source44: import.info

%description
Wiki2beamer converts a simple wiki-like syntax to complex LaTeX beamer code. 
It's written in python and should run on windows and all *nix platforms. Why 
collaborative? Because you can use it with version control systems. Afraid 
to loose some LaTeX powers? Don't worry: you can always fall back to plain 
LaTeX as wiki2beamer is just a preprocessor.

%prep
%setup -q -n %{name}-%{name}-v%{version}

for file in code/wiki2beamer tests/test_wiki2beamer.py; do
    sed -i '1s|^#!/usr/bin/env python|#!%{__python3}|' $file
done
mv doc/fdl.txt doc/LICENSE-DOCS

%build
pushd code/
%{__python3} setup.py build
popd

%install
pushd code/
%{__python3} setup.py install --skip-build --root %{buildroot}
popd

pushd doc/man/
asciidoctor -b manpage %{name}.adoc
install -p -m644 -D %{name}.1 %{buildroot}/%{_mandir}/man1/%{name}.1
popd

rm -r %{buildroot}/%{python3_sitelibdir_noarch}

%check
pushd tests
./test_wiki2beamer.py
popd

%files
%doc ChangeLog LICENSE README.md doc/LICENSE-DOCS doc/examples
%{_bindir}/wiki2beamer
%{_mandir}/man1/wiki2beamer.1*

%changelog
