# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           wmglobe
Version:        1.3
Release:        alt2_15
Summary:        A dock application displaying a spinning earth on a icon
License:        GPLv2
Group:          Sciences/Geosciences

URL:            http://web.cs.mun.ca/~gstarkes/wmaker/dockapps/other.html#wmglobe
Source0:        ftp://ftp.freebsd.org/pub/FreeBSD/ports/distfiles/%{name}-%{version}.tar.gz

#add CFLAGS variable in Makefile to allow for overloading and removing
#explicit stripping preventing debugfiles
Patch0:         wmglobe-1.3-makefile.patch
#fix security error on string litteral
Patch1:         wmglobe-1.3-fprintf.patch

BuildRequires:  glibc-devel glibc-devel-static
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xpm)
BuildRequires:  pkgconfig(xmu)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(ice)
BuildRequires:  pkgconfig(sm)
BuildRequires:  pkgconfig(xcb)
BuildRequires:  pkgconfig(xau)
BuildRequires:  pkgconfig(xdmcp)
BuildRequires:  pkgconfig(wrlib)
BuildRequires:  pkgconfig(libtiff-4)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  libjbig-devel
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  pkgconfig(liblzma)
BuildRequires:  libgif-devel
Source44: import.info


%description
Wmglobe is a WindowMaker dock application that displays the earth on
an icon. It uses a map which is rendered on a sphere by ray tracing.
Yes, for a 64x64 pixel result, that's why you want to see wmglobe!



%prep
%setup -q
%patch0 -p1 -b .cflagstrip
%patch1 -p1 -b .fprintf

iconv -f iso8859-1 -t utf-8 README > README.conv && mv -f README.conv README
iconv -f iso8859-1 -t utf-8 %{name}.1 > %{name}.1.conv && mv -f %{name}.1.conv %{name}.1


%build
%make_build CFLAGS="%optflags -fcommon" \
      LIBS=" -lX11 -lXext -lm -ltiff -lXpm -lpng -lz -ljpeg -lungif -lwraster"


%install
install -D -m 755 %{name} %{buildroot}%{_bindir}/%{name}
install -D -m 644 %{name}.1 %{buildroot}%{_mandir}/man1/%{name}.1


%files
%doc README CHANGES COPYING
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*




%changelog
