# BEGIN SourceDeps(oneline):
BuildRequires: perl(ctime.pl)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define         srcname       wmSpaceWeather

%add_optflags -fcommon

Name:           wmspaceweather
Version:        1.04
Release:        alt1_16
Summary:        A space weather monitor which displays cosmic ray fluxes from the Sun
License:        GPLv2
Group:          Sciences/Astronomy

URL:            https://www.dockapps.net/wmspaceweather
Source0:        https://www.dockapps.net/download/%{srcname}-%{version}.tar.gz

#fix url and search in GetKp to get fluxes
Patch0:         wmspaceweather-1.04-ftpctime.patch
#our compilation flags
Patch1:         wmspaceweather-1.04-cflags.patch
#fix parsing of current index file
Patch2:         wmspaceweather-1.04-curind.patch

BuildRequires:  glibc-devel glibc-devel-static
BuildRequires:  pkgconfig(xpm)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xext)

Requires: perl
Source44: import.info



%description
Wmspaceweather is another dockapp for WindowMaker, or any window
manager and desktop environment that handles dock applications. It
displays the current fluxes and spectra for electrons and protons at
geosynchronous orbit, as well as X-ray levels and the last K-index
values. The K-index is a measure of how disturbed the Earth's magnetic
field has been over a 3-hour interval which ranges from 0 to 9 (0
is quiet and 9 is very disturbed). The K-index values shown are the 8
previous values (i.e. the last 24 hours). If the display is
up-to-date, the led next to the K bars will flash blue, otherwise it
will flash orange.


%prep
%setup -q -n %{srcname}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
export CFLAGS="${CFLAGS:-%optflags}";
export CXXFLAGS="${CXXFLAGS:-%optflags}";
cd %{srcname}

%make_build clean
%make_build


%install
cd %{srcname}
install -D -m 755 GetKp %{buildroot}%{_bindir}/GetKp
install -D -m 755 %{srcname} %{buildroot}%{_bindir}/%{name}
install -D -m 644 %{srcname}.1 %{buildroot}%{_mandir}/man1/%{name}.1


%files
%doc BUGS CHANGES COPYING HINTS README
%{_bindir}/%{name}
%{_bindir}/GetKp
%{_mandir}/man1/%{name}.1*





%changelog
