# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: boost-devel gcc-c++ libGLU-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define engine  wyrmgus

Name:           wyrmsun
Version:        5.3.6
Release:        alt1_1
Summary:        Real-time strategy game based on history, mythology and fiction
Group:          Games/Strategy
License:        GPLv2+ and CC-BY-SA
URL:            https://www.indiedb.com/games/wyrmsun
Source0:        https://github.com/andrettin/wyrmgus/archive/v%{version}/%{engine}-%{version}.tar.gz
Source1:        https://github.com/andrettin/wyrmsun/archive/v%{version}/%{name}-%{version}.tar.gz
Source3:        %{name}-128.png

BuildRequires:  ccmake cmake ctest
BuildRequires:  doxygen
BuildRequires:  pkgconfig(bzip2)
BuildRequires:  pkgconfig(gl)
BuildRequires:  pkgconfig(libmikmod)
BuildRequires:  pkgconfig(libpng)
BuildRequires:  pkgconfig(physfs)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(SDL2_mixer)
BuildRequires:  pkgconfig(sqlite3)
BuildRequires:  pkgconfig(zlib)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(Qt5Core)
BuildRequires:  pkgconfig(Qt5Gui)
BuildRequires:  pkgconfig(Qt5Location)
BuildRequires:  pkgconfig(Qt5Multimedia)
BuildRequires:  pkgconfig(Qt5Qml)
BuildRequires:  pkgconfig(Qt5Quick)
BuildRequires:  pkgconfig(Qt5Widgets)
BuildRequires:  boost-complete
BuildRequires:  lua5.1-devel
BuildRequires:  liboaml-devel
BuildRequires:  libtolua++-lua5.1-devel
Requires:       %{name}-data >= %{version}-%{release}
Source44: import.info

%description
In the Wyrmsun universe a myriad of inhabited planets exist. Humans dwell
on Earth, while dwarves inhabit Nidavellir and elves nourish the world of
Alfheim. These peoples struggle to carve a place for themselves with their
tools of stone, bronze and iron. And perhaps one day they will meet one
another, beyond the stars...

%files
%doc Wyrmsun-%{version}/readme.txt
%{_metainfodir}/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_gamesbindir}/%{name}
%{_gamesbindir}/%{engine}
%{_iconsdir}/hicolor/128x128/apps/%{name}.png
%{_mandir}/man6/%{name}.6*

#----------------------------------------------------------------------

%package data
Group: Games/Strategy
Summary:        Data files for the Wyrmsun game
BuildArch:      noarch

%description data
This package contains arch-independent data files for the Wyrmsun game.

%files data
%{_gamesdatadir}/%{name}/

#----------------------------------------------------------------------

%prep
%setup -q -n Wyrmgus-%{version} -a1


%build
%{mageia_cmake} -DWITH_BZIP2=ON \
       -DWITH_PHYSFS=ON \
       -DENABLE_USEGAMEDIR=OFF
%mageia_cmake_build

%install
# Engine binary
install -D -m755 build/wyrmgus %{buildroot}%{_gamesbindir}/%{engine}

# Game data
pushd Wyrmsun-%{version}
install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a data fonts graphics interface maps modules music scripts sounds translations oaml.defs \
      %{buildroot}%{_gamesdatadir}/%{name}
install -D -m644 linux/wyrmsun.appdata.xml \
      %{buildroot}%{_metainfodir}/%{name}.appdata.xml
popd

# Launcher
install -d %{buildroot}%{_gamesbindir}
cat << EOF > %{buildroot}%{_gamesbindir}/%{name}
#!/bin/sh
%{engine} -d %{_gamesdatadir}/%{name} "\$@"
EOF
chmod +x %{buildroot}%{_gamesbindir}/%{name}

# Desktop entry
install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=Wyrmsun
GenericName=Strategy game
GenericName[fr]=Jeu de stratégie
Comment=Real-time strategy game based on history, mythology and fiction
Comment[fr]=Jeu de stratégie en temps réel basé sur l'histoire, la mythologie et la fiction
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;StrategyGame;
EOF

# Manpage
install -D -m644 doc/stratagus.6 \
        %{buildroot}%{_mandir}/man6/%{name}.6

# Icon
install -D -m644 %{_sourcedir}/%{name}-128.png \
        %{buildroot}%{_iconsdir}/hicolor/128x128/apps/%{name}.png


%changelog
