%filter_from_requires /python3.cons./d
%filter_from_requires /python3.core./d
%filter_from_requires /python3.globs./d

Group: Graphical desktop/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3 rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           x-tile
Version:        3.3
Release:        alt1_4
Summary:        A GTK application to tile windows in different ways

License:        GPLv2+
URL:            https://www.giuspen.com/x-tile/
Source0:        https://github.com/giuspen/%{name}/archive/%{version}/%{name}-%{version}.tar.gz
Source1:        %{name}.appdata.xml

BuildRequires:  desktop-file-utils
BuildRequires:  gettext gettext-tools
BuildRequires:  libappstream-glib
BuildRequires:  python3-devel
BuildRequires:  python3-module-setuptools
Requires:       python3-module-pygobject3 python3-module-pygobject3-pygtkcompat
Requires:       python3-module-pycairo
Requires:       gtk3-demo libgail3 libgtk+3 libgtk+3-schemas
Requires:       icon-theme-hicolor
BuildArch:      noarch
Source44: import.info

%description
X-tile is an application that allows you to select a number of windows and tile
them in different ways.  X-tile works on any X desktop (GNOME, KDE, XFCE,
LXDE...).
The main features are: many tiling geometries, undo tiling, invert tiling order,
optional system tray docking and menu, filter to avoid listing some windows,
filter to check some windows by default, command line interface.


%prep
%setup -q


# Remove bundled egg-info
rm -rf *.egg-info


%build
mkdir -p build/scripts-%{__python3_version}/
%python3_build


%install
%python3_install
install -Dpm 0755 %{name} $RPM_BUILD_ROOT%{_bindir}/%{name}
install -Dpm 0644 %{SOURCE1} $RPM_BUILD_ROOT%{_metainfodir}/%{name}.appdata.xml

%find_lang %{name}


%check
desktop-file-validate $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop
appstream-util validate-relax --nonet $RPM_BUILD_ROOT%{_metainfodir}/%{name}.appdata.xml


%files -f %{name}.lang
%doc --no-dereference license
%{_bindir}/%{name}
%{python3_sitelibdir_noarch}/X_Tile-*.egg-info
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.*
%{_metainfodir}/%{name}.appdata.xml
%{_mandir}/man1/%{name}.1*


%changelog
