%define _libexecdir %prefix/libexec
Group: File tools
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:          Simple tool to list expiring or expired X.509 certificates
Name:             x509watch
Version:          0.6.1
Release:          alt1_11
License:          GPLv2+
URL:              https://ftp.robert-scheck.de/linux/%{name}/
Source:           https://ftp.robert-scheck.de/linux/%{name}/%{name}-%{version}.tar.gz
Requires:         %{_bindir}/openssl
Requires:         %{_sbindir}/sendmail
BuildRequires:    libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-homed systemd-portable systemd-services systemd-sysvinit systemd-utils
BuildRequires:    rpm-build-perl
BuildArch:        noarch
Source44: import.info

%description
x509watch is a simple command line application, written in Perl, that can be
used to list soon expiring or already expired X.509 certificates, such as e.g.
SSL certificates. All certificates are searched by default in the standard PKI
directory, but any other directory can be specified as parameter. Only Base64
encoded DER and PEM X.509 certificates are supported.

%prep
%setup -q

%build

%install
%makeinstall_std

%postun
%systemd_postun %{name}.timer

%files
%doc --no-dereference COPYING
%doc ChangeLog README
%{_bindir}/%{name}
%{_libexecdir}/%{name}
%{_unitdir}/%{name}.service
%{_unitdir}/%{name}.timer
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}

%changelog
