Group: Video
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install /usr/bin/gccmakedep gcc-c++ imake libICE-devel libSM-devel libX11-devel libXrender-devel libXxf86vm-devel libexplain-devel libglvnd-devel liblirc-devel perl(Tk.pm) perl(Tk/Dialog.pm) perl(Tk/FileSelect.pm) perl(Tk/Frame.pm) perl(Tk/Table.pm) xorg-cf-files
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with	quicktime

Summary: TV applications for video4linux compliant devices
Name: xawtv
Version: 3.107
Release: alt2_11
License: GPLv2+
URL: http://linuxtv.org/wiki/index.php/Xawtv

Source0: http://linuxtv.org/downloads/xawtv/%{name}-%{version}.tar.bz2
Patch0: xawtv-strsignal.patch
Patch1: xawtv-3.107-XawListChange.patch

BuildRequires:  gcc
BuildRequires: libGL-devel, libXaw-devel, libXext-devel
BuildRequires: libXft-devel, libXinerama-devel
BuildRequires: libXpm libXpm-devel, libXrandr-devel, libXt-devel
BuildRequires: libXxf86dga-devel, libXv-devel
BuildRequires: libopenmotif-devel openmotif-clients
%{?with_quicktime:BuildRequires: libquicktime-devel}

BuildRequires: libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel, coreutils, libjpeg-devel libpng-devel libpng17-tools
BuildRequires: libalsa-devel
%ifnarch s390 s390x
BuildRequires: libdv-devel
%endif
BuildRequires: libzvbi-devel, aalib-devel
BuildRequires: libgpm-devel, libslang2-devel
BuildRequires: ImageMagick-tools desktop-file-utils libappstream-glib libappstream-glib-gir
BuildRequires: libv4l-devel
BuildRequires: perl-devel

Requires: consolehelper fonts-bitmap-misc icon-theme-hicolor
Source44: import.info

%description
Xawtv is a simple xaw-based TV program which uses the bttv driver or
video4linux. Xawtv contains various command-line utilities for
grabbing images and .avi movies, for tuning in to TV stations, etc.
Xawtv also includes a grabber driver for vic.


%package motv
Group: Video
Summary: MoTV Analog Television Viewer
Requires: %{name} = %{version}-%{release}

%description motv
Motif UI version of the xawtv analog television viewer.


%package mtt
Group: Video
Summary: Analog TV Teletext viewing application
Requires: %{name} = %{version}-%{release}

%description mtt
Easy to use Motif UI for viewing analog tv teletext on video4linux devices
which support teletext.


%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
export CFLAGS="$RPM_OPT_FLAGS -Wno-pointer-sign -fcommon"
%configure %{!?_with_quicktime: --disable-quicktime}
%make_build verbose=yes


%install
make DESTDIR=$RPM_BUILD_ROOT SUID_ROOT="" install

%if %{without quicktime}
rm -f $RPM_BUILD_ROOT%{_bindir}/showqt
%endif

for i in 16x16 32x32 48x48; do
  mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/$i/apps
  convert contrib/%{name}$i.xpm \
    $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/$i/apps/%{name}.png
done

mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
for i in xawtv motv mtt; do
   desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications \
       contrib/$i.desktop
   install -p -m 0644 contrib/$i.*.xml $RPM_BUILD_ROOT%{_datadir}/appdata
   appstream-util validate-relax --nonet \
       $RPM_BUILD_ROOT%{_datadir}/appdata/$i.*.xml
done

#   v4l-conf  stuff

mkdir -p $RPM_BUILD_ROOT%{_sbindir} \
	$RPM_BUILD_ROOT%{_sysconfdir}/pam.d \
	$RPM_BUILD_ROOT%{_sysconfdir}/security/console.apps \

cat >v4l-conf.pam <<!
#%%PAM-1.0
auth		sufficient	pam_rootok.so
auth		required	pam_console.so
account		required	pam_permit.so
session		required	pam_permit.so
session		optional	pam_xauth.so
!
install -m 0644 v4l-conf.pam $RPM_BUILD_ROOT%{_sysconfdir}/pam.d/v4l-conf

cat >v4l-conf.apps <<!
SESSION=true
USER=root
PROGRAM=%{_sbindir}/v4l-conf
!
install -p -m 0644 v4l-conf.apps $RPM_BUILD_ROOT%{_sysconfdir}/security/console.apps/v4l-conf

mv $RPM_BUILD_ROOT%{_bindir}/v4l-conf $RPM_BUILD_ROOT%{_sbindir}/
ln -s consolehelper $RPM_BUILD_ROOT%{_bindir}/v4l-conf

%files
%doc README TODO contrib/frequencies*
%doc --no-dereference COPYING
%config(noreplace) %{_sysconfdir}/pam.d/v4l-conf
%config(noreplace) %{_sysconfdir}/security/console.apps/v4l-conf
%{_bindir}/*
%exclude %{_bindir}/motv
%exclude %{_bindir}/mtt
%{_sbindir}/*
%{_libdir}/xawtv
%{_datadir}/xawtv
%{_x11appconfdir}/Xawtv
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_mandir}/man?/*
%exclude %{_mandir}/man1/motv.1*
%exclude %{_mandir}/man1/mtt.1*
%lang(es) %{_mandir}/es/*/*
%lang(fr) %{_mandir}/fr/*/*

%files motv
%{_bindir}/motv
%{_mandir}/man1/motv.1*
%{_x11appconfdir}/MoTV*
%lang(de) %{_sysconfdir}/X11/de_DE.UTF-8/app-defaults/MoTV*
%lang(fr) %{_sysconfdir}/X11/fr_FR.UTF-8/app-defaults/MoTV*
%lang(it) %{_sysconfdir}/X11/it_IT.UTF-8/app-defaults/MoTV*
%{_datadir}/appdata/motv.metainfo.xml
%{_datadir}/applications/motv.desktop

%files mtt
%{_bindir}/mtt
%{_mandir}/man1/mtt.1*
%{_x11appconfdir}/mtt*
%{_datadir}/appdata/mtt.metainfo.xml
%{_datadir}/applications/mtt.desktop


%changelog
