Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: glib2-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xdemorse
Version:        3.5
Release:        alt2_15
Summary:        GTK based application for decoding and displaying Morse code signals

License:        GPLv2+
URL:            http://www.qsl.net/5b4az/pkg/morse/xdemorse/xdemorse.html
Source0:        http://www.qsl.net/5/5b4az//pkg/morse/%{name}/%{name}-%{version}.tar.bz2
#Wrapper script for user config
Source3:        xdemorse.sh.in
Patch0:         %{name}-3.5-desktopfile.patch
Patch1:         %{name}-3.5-Makefile.patch
Patch2: xdemorse-configure-c99.patch

BuildRequires:  gcc-c++
BuildRequires:  gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel, desktop-file-utils, libalsa-devel
Source44: import.info

%description
xdemorse is a GTK+ graphical version of demorse, using the same
decoding engine as demorse.

It has an FFT-derived "waterfall" display of the incoming audio signal's
spectrum, as well as a 'scope-like display of the audio detector's output
and status of the mark/space discriminator ("slicer"). xdemorse also has
CAT for the FT-847 and this can be used to net the receiver's frequency
to the incoming signal, by clicking near its trace in the waterfall display.

%prep
%setup -q
%patch0 -p1 -b .desktop
%patch1 -p1 -b .makefile
%patch2 -p1

%build

%configure
%make_build


%install
mkdir -p $RPM_BUILD_ROOT%{_docdir}/%{name}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications/
mkdir -p $RPM_BUILD_ROOT%{_datadir}/pixmaps/
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1

make install DESTDIR=$RPM_BUILD_ROOT

#install default user configuration file
install -p -D -m 0644 .xdemorse/xdemorserc $RPM_BUILD_ROOT%{_datadir}/%{name}/
install -p -D -m 0644 .xdemorse/%{name}.glade $RPM_BUILD_ROOT%{_datadir}/%{name}/

#move original binary to libexecdir
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/
mv $RPM_BUILD_ROOT%{_bindir}/%{name} $RPM_BUILD_ROOT%{_libexecdir}/%{name}-bin

#install wrapper script
install -p -D -m 0755 %{SOURCE3} $RPM_BUILD_ROOT%{_bindir}/xdemorse

install -p -D -m 644 AUTHORS ChangeLog README doc/Morsecode.txt doc/%{name}.html $RPM_BUILD_ROOT%{_docdir}/%{name}

%files
%{_docdir}/%{name}
%doc --no-dereference COPYING
%{_bindir}/*
%{_libexecdir}/*
# wildcard _libexecdir/*
%exclude %_prefix/lib/debug
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/%{name}/xdemorserc
%{_datadir}/%{name}/%{name}.glade
%{_datadir}/applications/%{name}.desktop
%{_mandir}/man*/%{name}*

%changelog
