Group: Editors
# BEGIN SourceDeps(oneline):
BuildRequires: texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname xemacs-packages-base
%global hgver   cbe800ed9a7f
%global pkgdir  %{_datadir}/xemacs
%global xemver  21.5.34

Name:           xemacs-packages-base
Version:        20190327
Release:        alt2_5
Summary:        Base lisp packages for XEmacs

# dired and efs are GPL+, rest GPLv2+
License:        GPLv2+ and GPL+
URL:            http://www.xemacs.org/Documentation/packageGuide.html
# Tarball created with Source99
Source0:        %{name}-%{version}.tar.xz
Source99:       %{name}-checkout.sh

BuildArch:      noarch
BuildRequires:  makeinfo
BuildRequires:  xemacs-nox

Requires:       xemacs(bin) >= %xemver

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()
Source44: import.info

%description
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

This package contains the minimal recommended set of additional lisp
packages for XEmacs: efs, xemacs-base and mule-base from upstream.

%package        el
Group: Development/C
Summary:        Emacs lisp source files for the base lisp packages for XEmacs
Requires:       %{name} = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    el
This package is not needed to run XEmacs; it contains the lisp source
files for the base lisp packages for XEmacs, mainly of interest when
developing or debugging the packages.


%prep
%setup -q
cat << EOF > make.sh
#!/bin/sh
make \\
    XEMACS_BINARY=%{_bindir}/xemacs-nox \\
    XEMACS_INSTALLED_PACKAGES_ROOT=\$RPM_BUILD_ROOT%{pkgdir} \\
    XEMACS_21_5=t \\
    "\$@"
EOF
chmod +x make.sh

# Get reproducible builds by setting the compiling username
mkdir ~/.xemacs
echo >> ~/.xemacs/custom.el << EOF
(custom-set-variables
 '(user-mail-address "mockbuild@fedoraproject.org"))
EOF


%build
apkgs="apel dired efs fsf-compat xemacs-base"
xpkgs="efs xemacs-base"
mpkgs="mule-base"
./make.sh -C xemacs-packages autoloads PACKAGES="$apkgs"
./make.sh -C mule-packages   autoloads PACKAGES="$mpkgs"
./make.sh -C xemacs-packages           PACKAGES="$xpkgs"
./make.sh -C mule-packages             PACKAGES="$mpkgs"


%install
mkdir -p $RPM_BUILD_ROOT%{pkgdir}
./make.sh -C xemacs-packages/xemacs-base install
./make.sh -C xemacs-packages/efs         install
./make.sh -C mule-packages/mule-base     install

# separate files
rm -f *.files
touch base-files el-files

find $RPM_BUILD_ROOT%{pkgdir}/* \
  \( -type f -name '*.el.orig' -delete \) -o \
  \( -type f -not -name '*.el' -fprint base-non-el.files \) -o \
  \( -type d -not -name info -fprintf dir.files "%%%%dir %%p\n" \) -o \
  \( -name '*.el' \( -exec test -e '{}'c \; -fprint el-bytecomped.files -o \
     -fprint base-el-not-bytecomped.files \) \)

sed -i -e "s|$RPM_BUILD_ROOT||" *.files
cat base-*.files dir.files | grep -v /info/ >> base-files
cat el-*.files                              >> el-files

# all info files packaged in xemacs-packages-extra-info for simplicity
rm -rf $RPM_BUILD_ROOT%{pkgdir}/*-packages/info

sed -i -e 's/^\(.*\(\.ja\|-ja\.texi\)\)$/%lang(ja) \1/' base-files


%files -f base-files

%files el -f el-files


%changelog
