%add_findreq_skiplist /usr/share/xemacs/xemacs-packages/etc/bbdb/bbdb-srv.pl
Group: Editors
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ perl(diagnostics.pm) texinfo
# END SourceDeps(oneline)
BuildRequires: bdftopcf tex(manfnt.sty)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global hgver   cbe800ed9a7f
%global pkgdir  %{_datadir}/xemacs
%global xemver  21.5.34
%global basever 20190327

# This package install python files into nonstandard places
%global _python_bytecompile_extra 0

Name:           xemacs-packages-extra
Version:        20200216
Release:        alt1_7
Summary:        Collection of XEmacs lisp packages

License:        GPLv2+ and GPLv3+
URL:            http://www.xemacs.org/Documentation/packageGuide.html
# Tarball created with Source99
Source0:        %{name}-%{version}.tar.xz
Source10:       Emacs.ad.ja_JP.eucJP
Source11:       Emacs.ad.ko_KR.eucKR
Source12:       Emacs.ad.zh_CN.GB2312
Source13:       Emacs.ad.zh_TW.Big5
Source14:       Emacs.ad.ja_JP.UTF-8
Source15:       Emacs.ad.ko_KR.UTF-8
Source16:       Emacs.ad.zh_CN.UTF-8
Source17:       Emacs.ad.zh_TW.UTF-8
Source99:       %{name}-checkout.sh

# use TrAX by default in xslt-process
Patch0:         %{name}-20060510-trax.patch
# catch harmless errors in mouse-avoidance-too-close-p (avoid.el)
Patch1:         %{name}-20060510-avoid-catch-error-65346.patch
# make egg-wnn use unix domain sockets by default
Patch2:         %{name}-20060510-egg-wnn-host-unix-79826.patch
# use ptex rather than jtex by default for Japanese
Patch3:         %{name}-20150413-auctex-texjp-platex.patch
# adapt to python 3
Patch4:         %{name}-20190315-python3.patch
# fix an invalid eval-when list in prog-modes
Patch5:         %{name}-20190315-eval-when.patch
# add some missing dependencies that fail the build otherwise
Patch6:         %{name}-20190315-deps.patch
# switch from berkeley-db to gdbm now that XEmacs itself has
Patch7:         %{name}-20200216-gdbm.patch
# the @setcontentsaftertitlepage command has been removed from texinfo
Patch8:         %{name}-20200216-patcher.patch

BuildArch:      noarch
BuildRequires:  bdftopcf
BuildRequires:  glibc-gconv-modules
BuildRequires:  ImageMagick-tools
BuildRequires:  rpm-build-perl
BuildRequires:  xemacs
BuildRequires:  makeinfo
# For building auctex docs
BuildRequires:  tex(latex)
BuildRequires:  info info-install
BuildRequires:  python3-devel
BuildRequires:  java-devel
Requires:       xemacs-packages-base >= %{basever}
Requires:       xemacs(bin) >= %{xemver}
# Fake release here for historical reasons
Provides:       apel-xemacs = 10.7-1

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()
Source44: import.info

%description
XEmacs is a highly customizable open source text editor and
application development system.  It is protected under the GNU General
Public License and related to other versions of Emacs, in particular
GNU Emacs.  Its emphasis is on modern graphical user interface support
and an open software development model, similar to Linux.

The XEmacs packages collection contains a large collection of useful
lisp packages for XEmacs including mail readers, programming modes and
utilities, and packages related to using XEmacs in multi-lingual
environments.

%package        el
Group: Development/C
Summary:        Emacs lisp source files for XEmacs packages collection
Requires:       %{name} = %{version}-%{release}
Requires:       xemacs-packages-base-el >= %{basever}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    el
This package is not needed to run XEmacs; it contains the lisp source
files for the XEmacs packages collection, mainly of interest when
developing or debugging the packages.

%package        info
Group: Documentation
Summary:        XEmacs packages documentation in GNU texinfo format
Requires:       %{name} = %{version}-%{release}

# https://fedoraproject.org/wiki/Changes/Deprecate_xemacs
# https://bugzilla.redhat.com/show_bug.cgi?id=1916926
Provides:       deprecated()

%description    info
This package contains optional documentation for the XEmacs packages
collection in GNU texinfo format


%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1


chmod -c -x xemacs-packages/auctex/style/bidi.el

cat << EOF > make.sh
#!/bin/sh
make \\
    XEMACS_BINARY=%{_bindir}/xemacs \\
    XEMACS_INSTALLED_PACKAGES_ROOT=\$RPM_BUILD_ROOT%{pkgdir} \\
    XEMACS_21_5=t \\
    "\$@"
EOF
chmod +x make.sh

sed -i -e 's|/usr/local/bin/perl5\?|%{_bindir}/perl|g' \
  xemacs-packages/bbdb/utils/*.pl xemacs-packages/hyperbole/file-newer

# Fix encodings
for fil in mule-packages/mule-base/texi/canna-jp.texi \
           xemacs-packages/bbdb/texinfo/bbdb.texinfo \
           xemacs-packages/ecb/ecb.texi \
           xemacs-packages/edit-utils/tempo.texi \
	   xemacs-packages/general-docs/texi/xemacs/fontconfig.texi \
	   xemacs-packages/gnus/texi/emacs-mime.texi \
	   xemacs-packages/gnus/texi/gnus.texi \
	   xemacs-packages/hm--html-menus/hm--html-mode.texi \
	   xemacs-packages/hm--html-menus/umlaute.texi \
	   xemacs-packages/mmm-mode/mmm.texinfo \
           xemacs-packages/prog-modes/prog-modes.texi \
	   xemacs-packages/psgml/psgml.texi; do
  iconv -f iso8859-1 -t utf-8 $fil > $fil.utf8
  touch -f $fil $fil.utf8
  mv -f $fil.utf8 $fil.texi
done

# Get reproducible builds by setting the compiling username
mkdir ~/.xemacs
echo >> ~/.xemacs/custom.el << EOF
(custom-set-variables
 '(user-mail-address "mockbuild@fedoraproject.org"))
EOF

# Do not use env
for fil in xemacs-packages/python-modes/pydoc_lisp.py; do
  sed -ri.orig 's,bin/env (.*),bin/\13,' $fil
  touch -r $fil.orig $fil
  rm -f $fil.orig
done


%build
cd xemacs-packages/xslt-process/java
javac xslt/TrAX.java && jar cvf xslt.jar xslt/*.class && rm xslt/*.class
cd -
./make.sh autoloads
./make.sh


%install
mkdir -p $RPM_BUILD_ROOT%{pkgdir}
./make.sh install

# The X-Symbol font files are only needed on Windows
rm -fr $RPM_BUILD_ROOT%{pkgdir}/xemacs-packages/etc/x-symbol/fonts
rm -fr $RPM_BUILD_ROOT%{pkgdir}/xemacs-packages/etc/x-symbol/origfonts
rm -fr $RPM_BUILD_ROOT%{pkgdir}/xemacs-packages/etc/x-symbol/pcf

cd $RPM_BUILD_ROOT%{pkgdir}/mule-packages/etc/app-defaults
mkdir {de_DE,fr_FR,ro_RO,ja_JP,ko_KR,sv_SE,zh_CN,zh_TW}.UTF-8 \
  ja_JP.eucJP ko_KR.eucKR zh_CN.GB2312 zh_TW.Big5
iconv -f ISO-8859-1  -t UTF-8 de/Emacs > de_DE.UTF-8/Emacs
iconv -f ISO-8859-1  -t UTF-8 fr/Emacs > fr_FR.UTF-8/Emacs
iconv -f ISO-8859-16 -t UTF-8 ro/Emacs > ro_RO.UTF-8/Emacs
iconv -f ISO-8859-1  -t UTF-8 sv/Emacs > sv_SE.UTF-8/Emacs
mv de de_DE
mv fr fr_FR
mv ro ro_RO
mv sv sv_SE
install -pm 644 %{SOURCE10} ja_JP.eucJP/Emacs
install -pm 644 %{SOURCE11} ko_KR.eucKR/Emacs
install -pm 644 %{SOURCE12} zh_CN.GB2312/Emacs
install -pm 644 %{SOURCE13} zh_TW.Big5/Emacs
install -pm 644 %{SOURCE14} ja_JP.UTF-8/Emacs
install -pm 644 %{SOURCE15} ko_KR.UTF-8/Emacs
install -pm 644 %{SOURCE16} zh_CN.UTF-8/Emacs
install -pm 644 %{SOURCE17} zh_TW.UTF-8/Emacs
# these don't seem to appear in manifest
#ln -s ja_JP.eucJP ja_JP
#ln -s ko_KR.eucKR ko_KR
#ln -s zh_CN.GB2312 zh_CN
#ln -s zh_TW.Big5 zh_TW
cd -

remove_package() {
    pdir=$RPM_BUILD_ROOT%{pkgdir}/$2
    %{_bindir}/xemacs -batch -vanilla -l package-admin -eval \
        "(package-admin-delete-binary-package '$1 \"$pdir\")"
    rm -rf $pdir/{etc,lisp,man}/$1
}

# efs, xemacs-base: included in xemacs-packages-base
# jde: not buildable from sources, all deps not met, see 2006-03-03 changelog
for pkg in efs jde xemacs-base ; do
    remove_package $pkg xemacs-packages
done

# mule-base: included in xemacs-packages-base
# skk: provided by xemacs-ddskk
for pkg in mule-base skk ; do
    remove_package $pkg mule-packages
done

# mule-ucs: not needed (and unusable) with >= 21.5
remove_package mule-ucs mule-packages

# info docs: pre-generate "dir"s and compress files
for file in $RPM_BUILD_ROOT%{pkgdir}/*-packages/info/*.info ; do
  /sbin/install-info $file `dirname $file`/dir
done
find $RPM_BUILD_ROOT%{pkgdir} -type f -name '*.info*' | xargs gzip -9

# separate files
rm -f *.files
touch base-files el-files info-files

find $RPM_BUILD_ROOT%{pkgdir}/* \
  \( -type f -name '*.el.orig' -delete \) -o \
  \( -type f -not -name '*.el' -fprint base-non-el.files \) -o \
  \( -type d -not -name info -fprintf dir.files "%%%%dir %%p\n" \) -o \
  \( -name '*.el' \( -exec test -e '{}'c \; -fprint el-bytecomped.files -o \
     -fprint base-el-not-bytecomped.files \) \)

sed -i -e "s|$RPM_BUILD_ROOT||" *.files
cat base-*.files dir.files | grep -v /info/ >> base-files
cat el-*.files                              >> el-files
cat base-non-el.files | grep /info/         >> info-files

sed -i -e 's/^\(.*\(\.ja\|-ja\.texi\)\)$/%lang(ja) \1/' base-files
sed -i -e 's/^\(.*[_-]ja\.info.*\)$/%lang(ja) \1/' info-files

# Byte compile the python files
#py_byte_compile /usr/bin/python3 $RPM_BUILD_ROOT%{pkgdir}/xemacs-packages/etc/python-modes

# error: No such file or directory:
sort -u <<'EOF' > tmp1
/usr/share/xemacs/xemacs-packages/man/x-symbol/.ispell_xsymb
/usr/share/xemacs/xemacs-packages/man/x-symbol/Makefile.upstream
/usr/share/xemacs/xemacs-packages/man/x-symbol/x-symbol.init
/usr/share/xemacs/xemacs-packages/man/x-symbol/x-symbol.css
/usr/share/xemacs/xemacs-packages/man/ilisp/Makefile
/usr/share/xemacs/xemacs-packages/man/ilisp/doc-changes.txt
/usr/share/xemacs/xemacs-packages/man/ilisp/README
/usr/share/xemacs/xemacs-packages/man/gnus/doclicense.texi
/usr/share/xemacs/xemacs-packages/man/gnats/flowchart.txt
/usr/share/xemacs/xemacs-packages/man/gnats/states.texi
/usr/share/xemacs/xemacs-packages/man/gnats/s-usage.texi
/usr/share/xemacs/xemacs-packages/man/gnats/p-usage.texi
/usr/share/xemacs/xemacs-packages/man/gnats/p-inst.texi
/usr/share/xemacs/xemacs-packages/man/gnats/p-admin.texi
/usr/share/xemacs/xemacs-packages/man/gnats/fields.texi
/usr/share/xemacs/xemacs-packages/man/gnats/categ.texi
/usr/share/xemacs/xemacs-packages/man/auctex/copying.texi
/usr/share/xemacs/xemacs-packages/man/auctex/wininstall.texi
/usr/share/xemacs/xemacs-packages/man/auctex/tex-ref.tex
/usr/share/xemacs/xemacs-packages/man/auctex/preview-todo.texi
/usr/share/xemacs/xemacs-packages/man/auctex/preview-readme.texi
/usr/share/xemacs/xemacs-packages/man/auctex/preview-problems.texi
/usr/share/xemacs/xemacs-packages/man/auctex/preview-faq.texi
/usr/share/xemacs/xemacs-packages/man/auctex/preview-dtxdoc.texi
/usr/share/xemacs/xemacs-packages/man/auctex/todo.texi
/usr/share/xemacs/xemacs-packages/man/auctex/quickstart.texi
/usr/share/xemacs/xemacs-packages/man/auctex/macros.texi
/usr/share/xemacs/xemacs-packages/man/auctex/intro.texi
/usr/share/xemacs/xemacs-packages/man/auctex/install.texi
/usr/share/xemacs/xemacs-packages/man/auctex/fdl.texi
/usr/share/xemacs/xemacs-packages/man/auctex/faq.texi
/usr/share/xemacs/xemacs-packages/man/auctex/changes.texi
/usr/share/xemacs/xemacs-packages/man/semantic/tags.texi
/usr/share/xemacs/xemacs-packages/man/semantic/minor-modes.texi
/usr/share/xemacs/xemacs-packages/man/semantic/semanticheader.texi
/usr/share/xemacs/xemacs-packages/man/semantic/internals.texi
/usr/share/xemacs/xemacs-packages/man/semantic/fdl.texi
/usr/share/xemacs/xemacs-packages/man/semantic/installation.texi
/usr/share/xemacs/xemacs-packages/man/semantic/overview.texi
/usr/share/xemacs/xemacs-packages/man/semantic/glossary.texi
/usr/share/xemacs/xemacs-packages/man/os-utils/os-utils.texi
/usr/share/xemacs/xemacs-packages/man/elib/gpl.texi
/usr/share/xemacs/xemacs-packages/man/edit-utils/edit-utils.texi
EOF
sort -u base-files > tmp2
comm -13 tmp1 tmp2 > base-files

%files -f base-files
#%{pkgdir}/xemacs-packages/etc/python-modes/__pycache__

%files el -f el-files

%files info -f info-files
%dir %{pkgdir}/*-packages/info/


%changelog
