Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-generic-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:  Validating XML Parser
Name:     xerces-c27
Version:  2.7.0
Release:  alt1_31
License:  ASL 2.0
URL:      http://xml.apache.org/xerces-c/
Source0:  http://archive.apache.org/dist/xml/xerces-c/Xerces-C_2_7_0/source/xerces-c-src_2_7_0.tar.gz
Patch0:   xerces-c--CVE-2009-1885.diff
# Backports for CVE-2016-4463
# http://xerces.apache.org/xerces-c/secadv/CVE-2016-4463.txt
# http://svn.apache.org/viewvc?view=revision&revision=1747619
Patch1:   xerces-c27-cve-2016-4463.patch
# http://svn.apache.org/viewvc?view=revision&revision=1747620
Patch2:   xerces-c27-cve-2016-4463-mitigation.patch
# Backport for CVE-2017-12627
# https://xerces.apache.org/xerces-c/secadv/CVE-2017-12627.txt
# http://svn.apache.org/viewvc?view=revision&revision=1819998
Patch3:   xerces-c27-cve-2017-12627.patch

BuildRequires:  gcc-c++
BuildRequires:  sed
Source44: import.info

%description
Xerces-C is a validating XML parser written in a portable subset of C++.
Xerces-C makes it easy to give your application the ability to read and write
XML data. A shared library is provided for parsing, generating, manipulating,
and validating XML documents. Xerces-C is faithful to the XML 1.0
recommendation and associated standards ( DOM 1.0, DOM 2.0. SAX 1.0, SAX 2.0,
Namespaces).

Note that this package contains Xerces-C++ 2.7.0 for compatibility with
applications that cannot use a newer version.


%package  devel
Group: Development/Other
Summary:  Header files, libraries and development documentation for %{name}
Requires: %{name} = %{version}-%{release}

%description devel
This package contains the header files, static libraries and development
documentation for xerces-c 2.7.0. If you like to develop programs using
xerces-c 2.7.0, you will need to install %{name}-devel.

%package doc
Group: Documentation
Summary:  Documentation for Xerces-C++ validating XML parser
BuildArch: noarch

%description doc
Documentation for Xerces-C++ 2.7.0.

Xerces-C++ is a validating XML parser written in a portable subset of C++.
Xerces-C++ makes it easy to give your application the ability to read and
write XML data. A shared library is provided for parsing, generating,
manipulating, and validating XML documents.


%prep
%setup -q -n xerces-c-src_2_7_0

rm -rf doc/html/resources/.svn
find ./doc -type f -perm 755 -exec chmod 644 {} \;
find ./samples -type f -perm 755 -exec chmod 644 {} \;
sed -i -e "s|\(PREFIX.\)/lib\b|\1/%{_lib}|g" src/xercesc/configure */Makefile.in

iconv -f iso8859-1 -t utf-8 credits.txt > credits.txt.conv && mv -f credits.txt.conv credits.txt;
for i in feedback.xml migration.xml releases_archive.xml; do {
  iconv -f iso8859-1 -t utf-8 doc/$i > doc/$i.conv && mv -f doc/$i.conv doc/$i;
  };
done;

%patch0 -p0 -b .CVE-2009-1885
%patch1 -p1 -b .cve-2016-4463
%patch2 -p1 -b .cve-2016-4463-mitig
%patch3 -p1 -b .cve-2017-12627


%build
export XERCESCROOT="$PWD"

# Update the various config.guess to upstream release for aarch64/ppc64le support (and other new arches)
find ./ -name config.guess -exec cp /usr/lib/rpm/config.guess {} ';'

# Let Makefiles be verbose
find -name 'Makefile.*' | while read f; do
  sed -i -e 's/$Q//g' \
  -e 's/{MAKE} -s/(MAKE)/g' \
  -e '/echo \"  (/d' \
  $f
done

# Remove conflicting flags from runConfigure
find -name runConfigure | while read f; do
  sed -i -e 's/-w -O -DNDEBUG/-DNDEBUG/g' $f
done

cd $XERCESCROOT/src/xercesc
CXXFLAGS="${RPM_OPT_FLAGS}" CFLAGS="${RPM_OPT_FLAGS}" ./runConfigure -plinux -cgcc -xg++ -minmem -nsocket -tnative -rpthreads -b%{__isa_bits} -P %{_prefix} -C --libdir="%{_libdir}"
# not smp safe
make V=1


%install
export XERCESCROOT="$PWD"
make install -C src/xercesc DESTDIR="$RPM_BUILD_ROOT"
/sbin/ldconfig -n $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/xerces-c-2.7.0
cd $RPM_BUILD_ROOT%{_libdir}/xerces-c-2.7.0/
ln -s ../libxerces-c.so.27 libxerces-c.so
ln -s ../libxerces-depdom.so.27 libxerces-depdom.so
cd -
rm $RPM_BUILD_ROOT%{_libdir}/libxerces*.so
mkdir -p $RPM_BUILD_ROOT%{_includedir}/xercesc-2.7.0
mv $RPM_BUILD_ROOT%{_includedir}/xercesc $RPM_BUILD_ROOT%{_includedir}/xercesc-2.7.0





%files
%doc --no-dereference LICENSE LICENSE.txt
%{_libdir}/libxerces*.so.*


%files devel
%dir %{_libdir}/xerces-c-2.7.0
%{_libdir}/xerces-c-2.7.0/libxerces*.so
%{_includedir}/xercesc-2.7.0/


%files doc
%doc --no-dereference LICENSE LICENSE.txt
%doc Readme.html NOTICE STATUS credits.txt doc samples


%changelog
