Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           xfoil
Version:        6.99
Release:        alt2_20
Summary:        Subsonic Airfoil Development System

# Plotlib is LGPLv2+, the rest is GPLv2+
License:        GPLv2+ and LGPLv2+
URL:            http://web.mit.edu/drela/Public/web/xfoil/
Source0:        http://web.mit.edu/drela/Public/web/xfoil/%{name}%{version}.tgz
# The package does not ship a license file
Source1:        LICENSE.GPL
Source2:        LICENSE.LGPL
# Makefile variables and flags
Patch0:         xfoil-6.99-makefile.patch
# Code fixes (from debian package)
Patch1:         xfoil-6.99-xfoil-fixes.patch
Patch2:         xfoil-6.99-fix-write-after-end.patch
Patch3:         xfoil-6.99-pxplot-args.patch
# Set osmap file location
Patch4:         xfoil-6.99-default-osfile.patch

BuildRequires:  gcc-fortran libX11-devel
Requires:       fonts-bitmap-misc
Source44: import.info


%description
XFOIL is an interactive program for the design and analysis of subsonic
isolated airfoils.


%prep
%setup -q -n Xfoil
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

cp %{SOURCE1} .
cp %{SOURCE2} .


%build
export FFLAGS="-fallow-argument-mismatch %{optflags}"
export CFLAGS="%{optflags} -DDEFAULT_OSFILE=\\\"%{_datadir}/%{name}/osmap.dat\\\""

%make_build -C orrs/bin osgen
pushd orrs
./bin/osgen osmaps_ns.lst
popd
%make_build -C plotlib
%make_build -C bin


%install
%makeinstall_std -C bin BINDIR=%{_bindir}
install -Dpm 0644 orrs/osmap.dat %{buildroot}/%{_datadir}/%{name}/osmap.dat


%files
%doc --no-dereference LICENSE.GPL LICENSE.LGPL
%doc sessions.txt version_notes.txt xfoil_doc.txt
%{_datadir}/%{name}/
%{_bindir}/xfoil
%{_bindir}/pplot
%{_bindir}/pxplot


%changelog
