BuildRequires: perl(Pod/Man.pm)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		xls2csv
Version:		1.07
Release:		alt1_13
Summary:		A script that recodes a spreadsheet's charset and saves as CSV

Group:		Text tools
License:		GPL+ or Artistic
URL:			https://metacpan.org/release/xls2csv
Source0:		https://cpan.metacpan.org/authors/id/K/KE/KEN/%{name}-%{version}.tar.gz

BuildArch:	noarch
BuildRequires:	perl(ExtUtils/Embed.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/Harness.pm)
BuildRequires:	perl(Test/Simple.pm) perl(Unicode/Map.pm)
BuildRequires:	perl-devel rpm-build-perl perl(Locale/Recode.pm) perl(Text/CSV_XS.pm) perl(Spreadsheet/ParseExcel.pm)
Requires:		perl(Unicode/Map.pm)
Source44: import.info

%description
This script will recode a spreadsheet into a different character set
and output the recoded data as a csv file.

The script came about after many headaches from dealing with Excel
spreadsheets from clients that were being received in various character
sets.


%prep
%setup -q

%build
/usr/bin/perl Makefile.PL INSTALLDIRS="vendor" PREFIX="%{_prefix}"
make OPTIMIZE="$RPM_OPT_FLAGS"

%check
%{__make} test

%install
make pure_install DESTDIR=%{buildroot}

find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null ';'
chmod -R u+w %{buildroot}/*

# To avoid name conflict with catdoc package.
mv %{buildroot}%{_bindir}/%{name} %{buildroot}%{_bindir}/convert%{name}
gzip -c9 %{buildroot}%{_mandir}/man1/%{name}.1 > %{buildroot}%{_mandir}/man1/convert%{name}.1.gz
rm %{buildroot}%{_mandir}/man1/%{name}.1


%files
%doc
%attr(0755, root, root) %{_bindir}/convert%{name}
%{_mandir}/man1/convert%{name}.1*

%changelog
