%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major 0
%define libname libxmlrpc-epi%{major}
%define develname libxmlrpc-epi-devel

Summary:	An implementation of the XML-RPC protocol in C
Name:		xmlrpc-epi
Version:	0.54.2
Release:	alt1_13
License:	BSD
Group:		System/Libraries
URL:		http://xmlrpc-epi.sourceforge.net
Source0:	https://downloads.sourceforge.net/xmlrpc-epi/xmlrpc-epi-%{version}.tar.bz2
Patch0:		xmlrpc-epi-0.51-format_not_a_string_literal_and_no_format_arguments.diff
Patch1:		xmlrpc-epi-0.54-no_samples.diff
Patch2:		xmlrpc-epi-0.54.2-CVE-2016-6296.patch
Patch3:		xmlrpc-epi-0.54.2-php5.6.40.patch
BuildRequires:	pkgconfig(expat)
Source44: import.info

%description
xmlrpc-epi is an implementation of the xmlrpc protocol in C. It provides an 
easy to use API for developers to serialize RPC requests to and from XML.
It does *not* include a transport layer, such as HTTP. The API is primarily
based upon proprietary code written for internal usage at Epinions.com, and
was later modified to incorporate concepts from the xmlrpc protocol.

%package -n	%{libname} 
Summary:	Library providing XMLPC support in C
Group:		System/Libraries

%description -n	%{libname}
xmlrpc-epi is an implementation of the xmlrpc protocol in C. It provides an 
easy to use API for developers to serialize RPC requests to and from XML.
It does *not* include a transport layer, such as HTTP. The API is primarily
based upon proprietary code written for internal usage at Epinions.com, and
was later modified to incorporate concepts from the xmlrpc protocol.
 
%package -n	%{develname}
Summary:	Libraries, includes, etc. to develop XML and HTML applications
Group:		Development/C
Requires:	%{libname} = %{version}-%{release}
Provides:	libxmlrpc-devel = %{version}-%{release}
Provides:	xmlrpc-epi-devel = %{version}-%{release}

%description -n	%{develname}
xmlrpc-epi is an implementation of the xmlrpc protocol in C. It provides an
easy to use API for developers to serialize RPC requests to and from XML.
It does *not* include a transport layer, such as HTTP. The API is primarily
based upon proprietary code written for internal usage at Epinions.com, and
was later modified to incorporate concepts from the xmlrpc protocol.

%prep

%setup -q
%patch0 -p1 -b .format_not_a_string_literal_and_no_format_arguments
%patch1 -p0 -b .no_samples
%patch2 -p1 -b .CVE-2016-6296
%patch3 -p1 -b .php

# Make it lib64 aware
find . -name "Makefile.*" | xargs perl -pi -e "s,-L\@prefix\@/lib,,g"

perl -pi -e "s,-L/usr/local/lib\b,," configure*
perl -pi -e "s|withval/lib|withval/%{_lib}|g" configure*

%build
autoreconf -fi

%configure \
    --with-expat=%{_prefix}

#don't use parallel compilation, it is broken 
# (tpg) this is better ;)
%(echo %make|perl -pe 's/-j\d+/-j1/g')

%install
%makeinstall_std

# fix file conflicts
install -d %{buildroot}%{_includedir}/xmlrpc-epi
mv %{buildroot}%{_includedir}/*.h %{buildroot}%{_includedir}/xmlrpc-epi/


%files -n %{libname}
%doc AUTHORS COPYING ChangeLog README
%{_libdir}/lib*.so.%{major}*

%files -n %{develname}
%doc INSTALL
%dir %{_includedir}/xmlrpc-epi
%{_includedir}/xmlrpc-epi/*
%{_libdir}/lib*.so
# TODO: exclude *a
#%{_libdir}/lib*.a


%changelog
