Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install libX11-devel libXt-devel
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		xvarstar
Version:	0.9
Release:	alt1_23
Summary:	Astronomical program used for searching GCVS

License:	GPLv2+
URL:		http://virtus.freeshell.org/%{name}/
Source0:	http://virtus.freeshell.org/%{name}/%{name}-%{version}.tar.gz
Source1:	%{name}.desktop
# Public Domain icon
Source2:	http://openclipart.org/people/emyller/emyller_star.svg

BuildRequires:  gcc
BuildRequires:	desktop-file-utils
%if 0%{?rhel}
BuildRequires:	openmotif-devel
%else if 0%{?fedora} >= 24
BuildRequires:  libopenmotif-devel openmotif-clients
%else
BuildRequires:	lesstif-devel
%endif
Source44: import.info

%description
XVarStar is a astronomical program written for variable star observers, and is
 used for searching GCVS catalogue.  It allows searching by following criteria:
-star name 
-magnitude 
-type 
-constellation 
-amplitude 
-This searching criteria can be combined so one can search for example all 
variable stars located in Andromeda constellation and with magnitude 
brighter than 5.00.


%prep
%setup -q

%build
%configure
%make_build CFLAGS="%{optflags}"


%install
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p" \
  sysconfdir="$RPM_BUILD_ROOT%{_sysconfdir}"

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install --dir $RPM_BUILD_ROOT%{_datadir}/applications %{SOURCE1}
install -Dpm 0644 %{SOURCE2} $RPM_BUILD_ROOT%{_datadir}/pixmaps/xvarstar.svg


%files
%doc COPYING README
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_datadir}/pixmaps/xvarstar.svg
%{_datadir}/applications/%{name}.desktop

%config(noreplace) %{_sysconfdir}/%{name}.conf

%changelog
