Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/glib-gettextize /usr/bin/makedepend
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           yersinia
Version:        0.8.2
Release:        alt2_16
Summary:        Network protocols tester and attacker

License:        GPLv2+
URL:            http://www.yersinia.net/
Source0:        https://github.com/tomac/yersinia/archive/v%{version}.tar.gz#/%{name}-%{version}.tar.gz
Patch0:         yersinia-format-strings.patch
Patch1:         yersinia-configure-c99-1.patch
Patch2:         yersinia-configure-c99-2.patch

BuildRequires:  gcc
BuildRequires:  libpcap-devel
BuildRequires:  libnet2-devel
BuildRequires:  gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:  libncurses++-devel libncurses++w-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
Source44: import.info

%description
Yersinia is a network tool designed to take advantage of some weakeness
in different network protocols. It pretends to be a solid framework for
analyzing and testing the deployed networks and systems.

Currently, there are some network protocols implemented, but others are 
coming (tell us which one is your preferred). Attacks for the following
network protocols are implemented (but of course you are free for 
implementing new ones):

* Spanning Tree Protocol (STP)
* Cisco Discovery Protocol (CDP)
* Dynamic Trunking Protocol (DTP)
* Dynamic Host Configuration Protocol (DHCP)
* Hot Standby Router Protocol (HSRP)
* IEEE 802.1Q and IEEE 802.1X
* Inter-Switch Link Protocol (ISL)
* VLAN Trunking Protocol (VTP)

%prep
%setup -q -n %{name}-%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1


# Don't override CFLAGS in configure* (RHBZ#1240089)
sed -i -e "s,^\(\s*CFLAGS=\".*\"\),:\1," configure*
# Avoid rerunning the autotools
touch -r aclocal.m4 acinclude.m4 configure*

# Convert to utf-8
for file in THANKS; do
    mv $file timestamp
    iconv -f ISO-8859-1 -t UTF-8 -o $file timestamp
    touch -r timestamp $file
done

%build
%configure
%make_build CFLAGS="%{optflags} -fcommon"

%install
%makeinstall_std

%files
%doc AUTHORS ChangeLog FAQ README THANKS TODO
%doc --no-dereference COPYING
%{_mandir}/man?/%{name}.*
%{_bindir}/%{name}

%changelog
