Group: System/Servers
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/xmllint docbook-dtds
# END SourceDeps(oneline)
%define _libexecdir %_prefix/libexec
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: The NIS daemon which binds NIS clients to an NIS domain
Name: ypbind
Epoch: 3
Version: 2.7.2
Release: alt1_13
License: GPL-2.0-only
Url: https://www.thkukuk.de/nis/nis/ypbind-mt/

Source0: https://github.com/thkukuk/ypbind-mt/archive/v%{version}.tar.gz#/ypbind-mt-%{version}.tar.gz
#Source1: ypbind.init
Source2: nis.sh
Source3: ypbind.service
Source4: ypbind-pre-setdomain
Source5: ypbind-post-waitbind

# Fedora-specific patch. Renaming 'ypbind' package to proper
# 'ypbind-mt' would allow us to drop it.
Patch1: ypbind-1.11-gettextdomain.patch
# Not sent to upstream.
Patch2: ypbind-2.5-helpman.patch

# This is for /bin/systemctl
Requires: rpcbind
Requires: yp-tools >= 4.2.2
# New nss_nis package in F25+
Requires: glibc-nss
BuildRequires:  gcc
BuildRequires: libdbus-glib-devel, docbook-style-xsl
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
BuildRequires: libsystemd-devel libudev-devel
BuildRequires: autoconf, automake
BuildRequires: gettext-tools libasprintf-devel
BuildRequires: libtirpc-devel
BuildRequires: libnsl2-devel
BuildRequires: libxslt xsltproc
Source44: import.info

%description
The Network Information Service (NIS) is a system that provides
network information (login names, passwords, home directories, group
information) to all of the machines on a network. NIS can allow users
to log in on any machine on the network, as long as the machine has
the NIS client programs running and the user's password is recorded in
the NIS passwd database. NIS was formerly known as Sun Yellow Pages
(YP).

This package provides the ypbind daemon. The ypbind daemon binds NIS
clients to an NIS domain. Ypbind must be running on any machines
running NIS client programs.

Install the ypbind package on any machines running NIS client programs
(included in the yp-tools package). If you need an NIS server, you
also need to install the ypserv package to a machine on your network.

%prep
%setup -q -n ypbind-mt-%{version}
%patch1 -p1
%patch2 -p1


autoreconf -fiv

%build
%ifarch s390 s390x
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%else
export CFLAGS="$RPM_OPT_FLAGS -fpic"
%endif
export LDFLAGS="$LDFLAGS -pie -Wl,-z,relro,-z,now"

#export CFLAGS="$CFLAGS -H"

%configure
%make_build

%install
%makeinstall_std

mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/yp/binding
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/dhcp/dhclient.d
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}
install -m 644 etc/yp.conf $RPM_BUILD_ROOT%{_sysconfdir}/yp.conf
install -m 755 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/dhcp/dhclient.d/nis.sh
install -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{_unitdir}/ypbind.service
install -m 755 %{SOURCE4} $RPM_BUILD_ROOT%{_libexecdir}/ypbind-pre-setdomain
install -m 755 %{SOURCE5} $RPM_BUILD_ROOT%{_libexecdir}/ypbind-post-waitbind

%{find_lang} %{name}

%post
%post_service %{name}

%preun
%preun_service %{name}

%files -f %{name}.lang
%{_sbindir}/*
%{_mandir}/*/*
%{_libexecdir}/*
# wildcard _libexecdir/*
%exclude %_prefix/lib/debug
%{_unitdir}/*
%{_sysconfdir}/dhcp/dhclient.d/*
%config(noreplace) %{_sysconfdir}/yp.conf
%dir %{_localstatedir}/yp/binding
%doc README NEWS
%doc --no-dereference COPYING

%changelog
