Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/gcov
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           zipios
Version:        2.2.1.0
Release:        alt1_2
# Most of the project is under LGPLv2+ but two source filesa are GPLv2+ so the
# combined work is GPLv2+.
License:        GPLv2+
Summary:        C++ library for reading and writing Zip files

URL:            https://snapwebsites.org/project/zipios
Source0:        https://github.com/Zipios/Zipios/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  ctest cmake
BuildRequires:  gcc-c++ libstdc++-devel
BuildRequires:  catch2-devel
BuildRequires:  libtool
BuildRequires:  zlib-devel
BuildRequires:  cppunit-devel
BuildRequires:  graphviz libgraphviz
BuildRequires:  ImageMagick-tools
BuildRequires:  doxygen
# For man page generation
BuildRequires:  help2man
Source44: import.info


%description
Zipios is a java.util.zip-like C++ library for reading and writing
Zip files. Access to individual entries is provided through standard
C++ iostreams. A simple read-only virtual file system that mounts
regular directories and zip files is also provided.

Note: This is nearly a complete rewrite of the 1.x series by a new upstream.
The previous version is depreciated but still supported as zipios++.


%package devel
Group: Other
Summary:        Header files for zipios
Requires:       %{name} = %{version}-%{release}
Requires:       ctest cmake

%description devel
The header files are only needed for development of programs using %{name}.

Note: This is nearly a complete rewrite of the 1.x series by a new upstream.
The previous version is depreciated but still supported as zipios++.


%package doc
Group: Other
Summary:        Documentation for %{name}
BuildArch:      noarch
Requires:       %{name} = %{version}-%{release}

%description doc
Developer documentation for %{name}.


%prep
%setup -q -n Zipios-%{version}

sed -i "s/\-std=c++11//g" CMakeLists.txt


%build
rm -rf build && mkdir build && pushd build
%{fedora_cmake} -DCATCH_INCLUDE_DIR=%{_includedir}/catch \
       -DCMAKE_MODULES_INSTALL_DIR=%{_datadir}/cmake/Modules \
       -DBUILD_ZIPIOS_TESTS=FALSE \
       ../
%make_build


%install
pushd build
%makeinstall_std
# Create man pages
mkdir -p %{buildroot}%{_mandir}/man1
for bin in appendzip dosdatetime zipios; do
    help2man -s 1 -N tools/$bin > %{buildroot}%{_mandir}/man1/$bin.1
done
popd


%check
# Catch based testing is broken on gcc 6
# https://sourceforge.net/p/zipios/bugs/9/
# Test executable no longer compiles with gcc 7
# https://bugzilla.redhat.com/show_bug.cgi?id=1424569
# https://sourceforge.net/p/zipios/bugs/10/
#pushd build
#make run_zipios_tests





%files
%doc --no-dereference COPYING
%doc AUTHORS NEWS README.md TODO
%exclude %{_docdir}/%{name}/html/
%{_bindir}/*
%{_libdir}/*.so.*
%{_mandir}/man1/*.1*

%files devel
%{_libdir}/*.so
%{_datadir}/cmake/ZipIos/
%{_includedir}/%{name}
%{_mandir}/man3/*

%files doc
%{_docdir}/%{name}/html/


%changelog
