Group: System/Libraries
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:       ALSA C++ library
Name:          zita-alsa-pcmi
Version:       0.6.1
Release:       alt1_4
License:       GPLv3+ 
URL:           http://kokkinizita.linuxaudio.org
Source0:       http://kokkinizita.linuxaudio.org/linuxaudio/downloads/%{name}-%{version}.tar.bz2

BuildRequires: libalsa-devel
BuildRequires: gcc-c++
Source44: import.info

%description
%{name} is the successor of clalsadrv. It provides easy access
to ALSA PCM devices, taking care of the many functions required to
open, initialize and use a hw: device in mmap mode, and providing
floating point audio data.

%package       devel
Group: Development/Other
Summary:       Development libraries and headers for %{name}
Requires:      %{name} = %{version}-%{release}

%description   devel
This package contains the headers and development libraries for %{name}.


%package       utils
Group: Sound
Summary:       ALSA utilities using the %{name} library
Requires:      %{name} = %{version}-%{release}
# The following are GPLv2+ licensed:
# /apps/alsa_delay.cc, /apps/alsa_loopback.cc, /apps/mtmd.cc /apps/mtdm.cc
License:       GPLv2+ and GPLv3+

%description   utils
This package contains the headers and development libraries for %{name}.

%prep
%setup -q

# No -march=native and ldconfig in Makefile and preserve timestamps
sed -i -e '/^CXXFLAGS += -march=native/d' -e '/ldconfig/d' -e 's/install -m/install -p -m/g' source/Makefile
sed -i -e 's/install -m/install -p -m/g' apps/Makefile

# Patch wrong bin destdir (sent upstream by email on 20190803)
sed -i -e 's/install -d $(BINDIR)/install -d $(DESTDIR)$(BINDIR)/' apps/Makefile

%build


%make_build PREFIX=%{_prefix} LIBDIR=%{_libdir} -C source

# Create symlink to build apps
ln -sf lib%{name}.so.%{version} source/lib%{name}.so

%make_build PREFIX=%{_prefix} CXXFLAGS="${CXXFLAGS} -I../source" LDFLAGS="${LDFLAGS} -L../source" -C apps

%install
%makeinstall_std PREFIX=%{_prefix} LIBDIR=%{_libdir} -C source
%makeinstall_std PREFIX=%{_prefix} -C apps

%files
%doc AUTHORS README
%doc --no-dereference COPYING
%{_libdir}/lib%{name}.so.0*

%files devel
%{_includedir}/%{name}.h
%{_libdir}/lib%{name}.so

%files utils
%{_bindir}/alsa_delay
%{_bindir}/alsa_loopback

%changelog
